using System;
using System.Web;
using System.Collections;
using System.Web.Services;
using System.Web.Services.Protocols;
using AjaxControlToolkit;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Data;


/// <summary>
/// Summary description for EliteWebService
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
[System.Web.Script.Services.ScriptService()]

public class EliteWebService : System.Web.Services.WebService {

    public EliteWebService () {

        //Uncomment the following line if using designed components 
        //InitializeComponent(); 
    }

    [WebMethod]
    public string HelloWorld() {
        return "Hello World";
    }

    [WebMethod]
    public static string CheckReferenceListingAvailability(string pid)
    {

        return "haha";
    }

    [System.Web.Services.WebMethod]
    public static string ShowAvailability(string refId)
    {
        string errMsg;
        bool returnResult;
        int errCode;
        dbConn objConn = new dbConn();
        string _sql = "SELECT AppRefPID FROM tblPropListing " +
                      "WHERE AppRefPID = '" + refId + "'";

        returnResult = objConn.IfExist(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            return "Error";
        }
        else
        {
            return (returnResult) ? "True" : "False";
        }
    }


    [WebMethod]
    public CascadingDropDownNameValue[] GetProjectRoadName(
      string knownCategoryValues,
      string category)
    {
        dbConn objConn = new dbConn();
        DataTable mDt = new DataTable();
        string locCode;
        int errCode;
        string errMsg;

        StringDictionary location =
        AjaxControlToolkit.CascadingDropDown.
        ParseKnownCategoryValuesString(knownCategoryValues);

        locCode = (location["undefined"]);

        string _sql = "SELECT PID, PropertyTypeDesc FROM tblPropName WHERE Loc_Code = '" + locCode + "'";
        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        List<CascadingDropDownNameValue> ProjectRoadName = new List<CascadingDropDownNameValue>();

        foreach (DataRow dRow in mDt.Rows)
        {
            string PID = dRow["PID"].ToString();
            string PropertyTypeDesc = dRow["PropertyTypeDesc"].ToString();
            ProjectRoadName.Add(new CascadingDropDownNameValue
            (PropertyTypeDesc, PID));
        }

        return ProjectRoadName.ToArray();
    }


    [WebMethod]
    public CascadingDropDownNameValue[] GetPropertyType(
      string knownCategoryValues,
      string category)
    {
        StringDictionary propType =
           AjaxControlToolkit.CascadingDropDown.
           ParseKnownCategoryValuesString(knownCategoryValues);

        string _propType;
        int errCode;
        string errMsg;
        dbConn objConn = new dbConn();
        DataTable mDt = new DataTable();

        _propType = (propType["undefined"]);

        string _sql = "SELECT ID, PropertyDesc FROM tblPropType WHERE PropertyType = '" + _propType + "'";
        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        List<CascadingDropDownNameValue> PropertyType = new List<CascadingDropDownNameValue>();

        foreach (DataRow dRow in mDt.Rows)
        {
            string PID = dRow["ID"].ToString();
            string PropertyDesc = dRow["PropertyDesc"].ToString();
            PropertyType.Add(new CascadingDropDownNameValue
            (PropertyDesc, PID));
        }


        return PropertyType.ToArray();
    }

   

    
}

