using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;

/// <summary>
/// Summary description for dbConn
/// </summary>
public class dbConn
{

    string CONN = ConfigurationManager.ConnectionStrings["EliteDB"].ConnectionString; 

	public dbConn()
	{
		//
		// TODO: Add constructor logic here
		//
	}

    public DataTable GetDataReader2Dt(string sql, out int errCode, out string errMsg)
    {
        DataTable _dt = new DataTable();
        OleDbConnection oConn = null;

        try
        {
            oConn = new OleDbConnection(CONN);

            oConn.Open();

            OleDbCommand myCommand = new OleDbCommand(sql, oConn);
            OleDbDataReader rd = myCommand.ExecuteReader(CommandBehavior.CloseConnection);
            _dt.Load(rd);

            errCode = 0;
            errMsg = "";

            int y = _dt.Rows.Count;
        }
        catch (Exception _ex)
        {
            errCode = -1;
            errMsg = _ex.Message.ToString();
        }
        finally
        {
            // close the data connection
            oConn.Close();
        }

        return _dt;
    }


    public bool IfExist(string sqlCommand, out int ErrCode, out string ErrMsg)
    {
        OleDbConnection oConn = null;
        OleDbCommand oCmd = null;
        OleDbDataReader oDr = null;
        bool _exist = false;

        oConn = new OleDbConnection(CONN);
        oConn.Open();
        oCmd = oConn.CreateCommand();
        oCmd.CommandText = sqlCommand;
        oCmd.CommandType = CommandType.Text;

        try
        {
            oDr = oCmd.ExecuteReader();

            if (oDr.Read())
            {
                _exist = true;
            }
            else
            {
                _exist = false;
            }

            ErrCode = 0;
            ErrMsg = "";
        }
        catch (Exception ex)
        {
            ErrCode = -1;
            ErrMsg = ex.Message.ToString();
        }

        return _exist;
    }

    public object ExecScalar(string strSQL, out int ErrCode, out string ErrMsg)
    {
        OleDbConnection oConn = new OleDbConnection(CONN);
        OleDbCommand myCommand = new OleDbCommand(strSQL, oConn);
        object obj;

        try
        {
            // open the data connection
            oConn.Open();
            // execute the command
            // returns the first column of the first row in the result set r
            obj = myCommand.ExecuteScalar();

            ErrCode = 0;
            ErrMsg = "";
        }
        catch (Exception e)
        {
            ErrCode = -1;
            ErrMsg = e.Message.ToString();
            obj = null;
            throw e;
        }
        finally
        {
            // close the data connection
            oConn.Close();
        }

        return obj;

    }

    public DataTable GetDataTable(string sqlCommand, out int ErrCode, out string ErrMsg)
    {
        DataTable subs = new DataTable("tCommon");


       
            using (OleDbConnection oConn = new OleDbConnection(CONN))
            {
                OleDbCommand selectAllSub = oConn.CreateCommand();

                selectAllSub.CommandText = sqlCommand;
                
                try
                {
                oConn.Open();
                subs.Load(selectAllSub.ExecuteReader(CommandBehavior.CloseConnection));
                ErrCode = 0;
                ErrMsg = "";
                }
                catch (Exception e)
                {
                    ErrCode = -1;
                    ErrMsg = e.Message.ToString();
                    throw e;
                }
                finally
                {
                    oConn.Close();
                }
            }
     
   

        return subs;
    }

    public DataSet GetDS(string sqlCommand, out int ErrCode, out string ErrMsg)
    {
        //Dim DBConn as OleDbConnection
        //Dim DBCommand As OleDbDataAdapter
        //Dim DSPageData as New DataSet
        OleDbConnection DBConn;
        DBConn = new OleDbConnection(CONN);
        OleDbDataAdapter DBAdapter;
        DataSet DS = new DataSet();
        try
        {
          
            DBAdapter = new OleDbDataAdapter(sqlCommand, DBConn); 
            DBAdapter.Fill(DS, "tbl");
            ErrCode = 0;
            ErrMsg = "";
        }
        catch (Exception e)
        {
            ErrCode = -1;
            ErrMsg = e.Message.ToString();
            throw e; 
        }
        finally
        {
            if (DBConn.State == ConnectionState.Open)
            {
                DBConn.Close();
            }
        }
       

        return DS;

    }

    public int getMax(string sqlString, out int ErrCode, out string ErrMsg)
    {
        int getMaxVal = 0;
        OleDbConnection DBConn;
        DBConn = new OleDbConnection(CONN);
        OleDbCommand _cmd = new OleDbCommand(sqlString, DBConn);


        try
        {

            DBConn.Open();

            if (_cmd.ExecuteScalar() == null)
            {
                getMaxVal = 0;
            }
            else
            {
                getMaxVal = Convert.ToInt32(_cmd.ExecuteScalar().ToString());
            }

            
            ErrCode = 0;
            ErrMsg = "";

        }
        catch (Exception e)
        {
            ErrCode = -1;
            ErrMsg = e.Message.ToString();
            throw e;
        }
        finally
        {
            DBConn.Close();
        }



   
        return getMaxVal;
    }

    public int ExecSQL(string strSQL, out int ErrCode, out string ErrMsg)
    {
        int exeResult = 0;
        OleDbConnection conn = new OleDbConnection(CONN);

        conn.Open();

    OleDbCommand _cmd = new OleDbCommand();

        try
        {
    

            _cmd.Connection = conn;
            _cmd.CommandText = strSQL;
            _cmd.CommandTimeout = 600;
            exeResult = _cmd.ExecuteNonQuery();

            ErrCode = 0;
            ErrMsg = "";

        }
        catch (Exception e)
        {
            ErrCode = -1;
            ErrMsg = e.Message.ToString();
            //throw e;
        }
        finally
        {
            conn.Close();
            conn.Dispose();
            _cmd = null;
        }

        return exeResult;
    }

}
