using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ApprovalProcess : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        if (!Page.IsPostBack)
        {
            loadPendingListing();
        }
    }

    private void loadPendingListing()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        DataTable mDt = new DataTable();

        string sql = "SELECT P.Ref_Cd & P.Ref_Id AS PID, P.AppRefPID, P.BuiltUp_Area, P.Land_Area, L.Loc_Name, " +
                     "P.AskingPrice, P.Tenure, P.PropertyCondition, P.RentingPrice, P.PropertyCode," +
                     "T.PropertyDesc, U.user_name,  " +
                     "(SELECT COUNT(*) AS ImgCnt FROM tblPropImage I WHERE I.ImageActive = 1 AND P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id) As ImgCnt " +
                     "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.location = L.Loc_Code) " +
                     "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
                     "INNER JOIN tblPropUser U ON U.ID = P.InsBy " +
                     "WHERE P.PActive = " + Convert.ToInt16(CUtil.listingStatus.Pending_Approval).ToString();
      

        mDt = objConn.GetDataReader2Dt(sql, out errCode, out errMsg);

        if (mDt.Rows.Count == 0)
        {
            lblSysErrMsg.Text = "No data found";
        }


        if (errCode == -1)
        {
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            gvApproval.DataSource = mDt;
            gvApproval.DataBind();
        }

        gvApproval.SelectedIndex = -1;

    }
    protected void gvApproval_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            CUtil outil = new CUtil();

            DataRowView drv = (DataRowView)(e.Row.DataItem);
            string AskingPrice = drv["AskingPrice"].ToString();
            string RentingPrice = drv["RentingPrice"].ToString();

            Label lblAskingPrice = (Label)e.Row.FindControl("lblAskingPrice");
            Label lblRentingPrice = (Label)e.Row.FindControl("lblRentingPrice");

            if (lblAskingPrice != null)
              {
                  lblAskingPrice.Text = "RM " + outil.factorPrice(AskingPrice);
                  lblRentingPrice.Text = "RM " + outil.factorPrice(RentingPrice);
              }
        }
    }
    protected void gvApproval_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Approve")
        {
            dbConn objConn = new dbConn();
            int errCode;
            string errMsg;

            Control ctl = e.CommandSource as Control;
            GridViewRow CurrentRow = ctl.NamingContainer as GridViewRow;


            string dataKey =gvApproval.DataKeys[CurrentRow.RowIndex].Values[0].ToString();

            string sSQL = "UPDATE tblPropListing SET PActive = 1 WHERE  Ref_Cd & Ref_Id = '" + dataKey + "'";

            objConn.ExecSQL(sSQL, out errCode, out errMsg);

            if (errCode == -1)
            {

                lblSysErrMsg.Text = errMsg;
            }
            else
            {

                loadPendingListing();
            }

        }
    }
    protected void gvApproval_SelectedIndexChanged(object sender, EventArgs e)
    {
      
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {

    }

    protected void gvApproval_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
       
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string dataKey = gvApproval.DataKeys[e.NewSelectedIndex].Values[0].ToString();

        ViewState["dataKey"] = dataKey;

        DataTable mDt = new DataTable();

        string sSQL = "SELECT P.Ref_Cd & P.Ref_Id AS PID, P.AppRefPID, P.BuiltUp_Area, P.Land_Area, L.Loc_Name, " +
                     "P.AskingPrice, P.Tenure, P.TYear, P.ExpiredDate, P.PropertyCondition, P.RentingPrice, P.PropertyCode," +
                     "P.NoOfBedRoom, P.NoOfBathRoom, P.FurnishedCondition, P.InsDate, " +
                     "T.PropertyDesc, U.user_name,  " +
                     "(SELECT COUNT(*) AS ImgCnt FROM tblPropImage I WHERE I.ImageActive = 1 AND P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id) As ImgCnt " +
                     "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.location = L.Loc_Code) " +
                     "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
                     "INNER JOIN tblPropUser U ON U.ID = P.InsBy " +
                     "WHERE P.Ref_Cd & P.Ref_Id = '" + dataKey + "'";


        mDt = objConn.GetDataReader2Dt(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        { lblSysErrMsg.Text = errMsg; }
        else
        {

            foreach (DataRow row in mDt.Rows)
            {
                lblSysInsertBy.Text = row["user_name"].ToString();
                lblPostedDate.Text = Convert.ToDateTime(row["InsDate"]).ToShortDateString();
                lblPropertyID.Text = (string)row["PID"];
                lblSysRefID.Text = row["AppRefPID"].ToString();
                lblLandArea.Text = row["Land_Area"].ToString();
                lblBuiltUpArea.Text = row["BuiltUp_Area"].ToString();
                lblBedroom.Text = row["NoOfBedRoom"].ToString();
                lblBathroom.Text = row["NoOfBathRoom"].ToString();
                lblCondition.Text = row["PropertyCondition"].ToString();
                lblFurnish.Text = row["FurnishedCondition"].ToString();
                lblTenure.Text = row["Tenure"].ToString();
                lblYearLeft.Text = row["TYear"].ToString() + "&nbsp;&nbsp;" + "Expired Date : " + row["ExpiredDate"].ToString();
                CUtil obj = new CUtil();

                lblSalesPrice.Text = "Rm " + obj.factorPrice(row["AskingPrice"].ToString());
                lblRentPrice.Text = "Rm " + obj.factorPrice(row["RentingPrice"].ToString());
                lblPropType.Text = row["PropertyDesc"].ToString();
                lblLocation.Text = row["Loc_Name"].ToString();
                lblProjRdName.Text = row["PropertyCode"].ToString();
              
            }
        }


        ModalPopupListingInfo.Show();
    }
    protected void btnReject_Click(object sender, EventArgs e)
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string sSQL = "UPDATE tblPropListing SET PActive = '" + Convert.ToInt16(CUtil.listingStatus.Rejected).ToString() + "' " +
                  "WHERE  Ref_Cd & Ref_Id = '" + ViewState["dataKey"].ToString() + "'";

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        {

            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            loadPendingListing();
        }
    }

    protected void btnApprove_Click(object sender, EventArgs e)
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string sSQL = "UPDATE tblPropListing SET PActive = '" + Convert.ToInt16(CUtil.listingStatus.Active).ToString() + "' " +
                      "WHERE  Ref_Cd & Ref_Id = '" + ViewState["dataKey"].ToString() + "'";

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            loadPendingListing();
        }
    }


    protected void btnEdit_Click(object sender, EventArgs e)
    {
        Response.Redirect("managePropertyListing.aspx?PID=" + ViewState["dataKey"].ToString());
    }

}
