using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.IO;
using System.Xml;

public partial class CRUDPropertyPage : System.Web.UI.Page
{
    public const int EDIT_MODE = 1;
    public const int NEW_MODE = 2;

    public struct ImgSize
    {
        public int _Width;
        public int _Height;

    }

    public ImgSize thumbnailCal(decimal _h, decimal _w, int _size)
    {
        int thumbHeight;
        int thumbWidth;

        ImgSize _imgS = new ImgSize();

        //if (_h < _w)
        //{
        //    thumbHeight = _size;
        //    decimal tWidth = (_w / _h) * thumbHeight;
        //    thumbWidth = Convert.ToInt32(tWidth);
        //}
        //else
        //{
        //    thumbWidth = _size;
        //    decimal tHeight = (_h / _w) * thumbWidth;
        //    thumbHeight = Convert.ToInt32(tHeight);
        //}

        //_imgS._Height = thumbHeight;
        //_imgS._Width = thumbWidth;

        if (_h > _w)
        {
            _imgS._Width = (int)(_w * ((decimal)_size / (decimal)_h));
            _imgS._Height = _size;
        }
        else
        {
            _imgS._Width = _size;
            _imgS._Height = (int)(_h * ((decimal)_size / (decimal)_w));
        }

        return _imgS;


    }

    public void loadPropertyImg()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string _sql;
        string LID = lblPropertyID.Text;

        _sql = "SELECT ImageFileName, ImageThumbNailLocation_1, ImageProfilePic FROM tblPropImage WHERE " +
               "Ref_Cd & Ref_Id = '" + LID + "'";

        DataTable mDt = new DataTable();

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        rpImage.DataSource = mDt;
        rpImage.DataBind();
    }

    public void loadSelectionData()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string _sql = "SELECT ID, PropertyDesc FROM tblPropType";
        DataTable mDt = new DataTable();
        DataTable mDt2 = new DataTable();

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);



        //_sql = "SELECT Loc_Code AS LOCCode, Loc_Name FROM tblPropLocation";
        //mDt2 = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        //if (errCode == 0)
        //{

        //    mDt2.Rows.Add(new object[] { 0, "Please Select" });
        //    ddlLocation.DataSource = mDt2;
        //    ddlLocation.DataTextField = "Loc_Name";
        //    ddlLocation.DataValueField = "LOCCode";
        //    ddlLocation.DataBind();
        //    ddlLocation.SelectedValue = "0";
        //}
        //else
        //{
        //    lblSysErrMsg.Text = errMsg;
        //    return;

        //}

        

    }

    public void pageMode(int _mode, string _PID)
    {
        //txtEAppPropRefID
        if (_mode == EDIT_MODE)
        {
            dbConn objConn = new dbConn();
            int errCode;
            string errMsg;
            DataTable mDt = new DataTable();

            btnSave.Visible = false;
            btnUpdate.Visible = true;
            btnSold.Visible = true;
            string askingPrice;

            string _sql = "SELECT L.location, L.PropertyCode, L.PropertyType, L.BuiltUp_Area, L.Land_Area, L.PDesc, L.PropertySpec, " +
                          "L.PropertyCondition, L.FurnishedCondition, L.Tenure, L.NoOfBedRoom, L.NoOfBathRoom, L.Exclusive, " +
                          "L.TYear, L.ExpiredDate, " +
                          "L.AskingPrice, L.RentingPrice, L.AppRefPID, L.PStatus, T.PropertyDesc " +
                          "FROM tblPropListing L INNER JOIN tblPropType T ON T.ID = L.PropertyType " +
                          "WHERE Ref_Cd & Ref_Id = '" + _PID + "'";

            mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

            if (errCode == 0)
            {

                DataRow DR;
                DR = mDt.Rows[0];
                lblPropertyID.Text = _PID;

                // None editable
                ddlPropertyCat.SelectedValue = _PID.Substring(0, 1);
                WUCFT.selectedValue = DR["location"].ToString();

                lblPropType.Visible = true;
                lblPropType.Text = DR["PropertyDesc"].ToString();
                ddlPropType.Attributes.Add("style", "visibility :hidden");

                // ddlPropType.SelectedValue = DR["PropertyType"].ToString();

                ddlPropertyCat.Enabled = false;
                //ddlLocation.Enabled = false;
                ddlPropType.Enabled = false;
             

                askingPrice = DR["AskingPrice"].ToString();

                if (DR["PStatus"].ToString() == "2")
                {
                    btnSold.Visible = false;
                }

                if (askingPrice.Length > 6)
                {
                    if (askingPrice.Substring(askingPrice.Length - 6) == "000000")
                    {
                        //cbThous.Checked = false;
                        //cbMil.Checked = true;
                   
                        txtAskingPrice.Text = askingPrice.Remove(askingPrice.Length - 6);
                    }
                    else if (askingPrice.Substring(askingPrice.Length - 3) == "000")
                    {
                        cbThous.Checked = true;
                        cbMil.Checked = false;
                        txtAskingPrice.Text = askingPrice.Remove(askingPrice.Length - 3);
                    }
                    else
                    {
                        cbThous.Checked = false;
                        cbMil.Checked = false;
                        txtAskingPrice.Text = askingPrice;
                    }
                }
                else if (askingPrice.Length > 3)
                {
                    if (askingPrice.Substring(askingPrice.Length - 3) == "000")
                    {
                        cbThous.Checked = true;
                        cbMil.Checked = false;
                        txtAskingPrice.Text = askingPrice.Remove(askingPrice.Length - 3);
                    }
                    else
                    {
                        cbThous.Checked = false;
                        cbMil.Checked = false;
                        txtAskingPrice.Text = askingPrice;
                    }
                }
                else
                {
                    cbThous.Checked = false;
                    txtAskingPrice.Text = askingPrice;
                }

                txtEAppPropRefID.Text = DR["AppRefPID"].ToString();
                txtrdProjName.Text = DR["PropertyCode"].ToString();

                ddlLandedStorey.SelectedValue = DR["PropertySpec"].ToString();


                //cbThous.Enabled = false;

                if (DR["Exclusive"].ToString() == "1")
                {
                    cbExclusive.Checked = true;
                }
                else
                {
                    cbExclusive.Checked = false;
                }

                txtBoxAppNoBathroom.Text = DR["NoOfBathRoom"].ToString();
                txtBoxAppNoBedroom.Text = DR["NoOfBedRoom"].ToString();
                txtBoxLandedNoBathroom.Text = DR["NoOfBathRoom"].ToString();
                txtBoxLandedNoBedroom.Text = DR["NoOfBedRoom"].ToString();
                txtRentingPrice.Text = DR["RentingPrice"].ToString();
                rdBtnListTenure.SelectedValue = DR["Tenure"].ToString();
                rdBtnListPropCond.SelectedValue = DR["PropertyCondition"].ToString();
                rdBtnListFurCond.SelectedValue = DR["FurnishedCondition"].ToString();
                txtLandArea.Text = DR["Land_Area"].ToString();
                txtBuiltUpArea.Text = DR["BuiltUp_Area"].ToString();
                txtDesc.Text = DR["PDesc"].ToString();

                txtLeaseHoldYear.Text = DR["TYear"].ToString();
                txtExpiredYear.Text = DR["ExpiredDate"].ToString(); 


                
                if (_PID.StartsWith("S"))
                {
                    Tabs.ActiveTabIndex = 1;
                }
                else if (_PID.StartsWith("L"))
                {
                    Tabs.ActiveTabIndex = 2;
                }
                else if (_PID.StartsWith("C"))
                {
                    Tabs.ActiveTabIndex = 3;
                }
                else if (_PID.StartsWith("F"))
                {
                    Tabs.ActiveTabIndex = 4;
                }

              

            }
            else
            {

                lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
                lblSysErrMsg.Text = errMsg;
            }



            // FILL In data
        }
        else
        {
       

           
            btnSave.Visible = true;
            btnUpdate.Visible = false;
            btnSold.Visible = false;
          
            btnRented.Visible = false;
        }

        if (Session["user_accesslevel"].ToString() == "1")
        {
            cbExclusive.Enabled = true;
        }
        else
        {
            cbExclusive.Enabled = false;
        }
    }

    public void pageInit()
    {
        if (Request.QueryString["PID"] == null)
        {

            pageMode(NEW_MODE, "0");
        }
        else
        {

            pageMode(EDIT_MODE, Request.QueryString["PID"].ToString());
        }
    }

    public bool FnCast(string vi)
    {
        //if (vi == "1"
        bool rtn = (vi == "1") ? true : false;
        return rtn;
    }

    protected void page_Init(object sender, EventArgs e)
    {
        //MyAccordion.FindControl("nothing");
    }

    private string GetExtension(string FileName)
    {
        string[] split = FileName.Split('.');
        string Extension = split[split.Length - 1];
        return Extension;
    }

    private string GetFileNameOnly(string FileName)
    {
        string[] split = FileName.Split('.');
        string Extension = split[0];
        return Extension;
    }


    /// <summary>
    /// Resize and create watermark
    /// </summary>
    /// <param name="imageFile"></param>
    /// <param name="_targetSize"></param>
    /// <returns></returns>
    public byte[] ReSizeImageFile(byte[] imageFile, ImgSize _targetSize, string _watermark)
    {

        Font font = new Font("Arial", 22, FontStyle.Bold, GraphicsUnit.Pixel);
        Color color = Color.FromArgb(254, 254, 0, 80);
        //Adds a black watermark with a low alpha value (almost transparent).
        //The pixel point to draw the watermark at (this example puts it at 100, 100 (x, y)).
        SolidBrush brush = new SolidBrush(color);

        MemoryStream ms = new MemoryStream(imageFile);

        using (System.Drawing.Image oldImage =
                    System.Drawing.Image.FromStream(ms))
        {
            Size newSize = CalculateDimensions(oldImage.Size, _targetSize);

            using (Bitmap newImage =
                new Bitmap(newSize.Width, newSize.Height, PixelFormat.Format24bppRgb))
            {
                using (Graphics canvas = Graphics.FromImage(newImage))
                {
                    canvas.SmoothingMode = SmoothingMode.AntiAlias;
                    canvas.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    canvas.PixelOffsetMode = PixelOffsetMode.HighQuality;

                    canvas.DrawImage(oldImage,
                        new Rectangle(new Point(0, 0), newSize));


                    int _X = newSize.Width / 2;
                    int _Y = newSize.Height / 2;

                    Point atPoint = new Point(_X, _Y);
                    StringFormat sf = new StringFormat();
                    sf.Alignment = StringAlignment.Center;
                    sf.LineAlignment = StringAlignment.Center;

                    canvas.DrawString(_watermark, font, brush, atPoint, sf);

                    MemoryStream m = new MemoryStream();
                    newImage.Save(m, ImageFormat.Jpeg);
                    return m.GetBuffer();

                }

            }
        }
    }

    private Size CalculateDimensions(Size oldSize, ImgSize _ImgSize)
    {
        Size newSize = new Size();
        if (oldSize.Height > oldSize.Width)
        {
            newSize.Width = (int)(oldSize.Width * ((float)_ImgSize._Width / (float)oldSize.Height));
            newSize.Height = _ImgSize._Height;
        }
        else
        {
            newSize.Width = _ImgSize._Width;
            newSize.Height = (int)(oldSize.Height * ((float)_ImgSize._Height / (float)oldSize.Width));
        }
        return newSize;
    }


    private void loadXmlData()
    {
        XmlDocument doc = new XmlDocument();
        doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));
        XmlNode root = doc.DocumentElement;
        string ImgFileSize = root.SelectSingleNode("ImgFileSize").ChildNodes[0].Value;
        lblMaxSize.Text = ImgFileSize;
   }

    protected void Page_Load(object sender, EventArgs e)
    {

        HtmlLink link = new HtmlLink();
        HtmlLink link2 = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        link2.Href = "CSS/ajaxtoolkit.css";
        link2.Attributes.Add("rel", "stylesheet");
        link2.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link2);

        

        if (!Page.IsPostBack)
        {
            loadSelectionData();
            pageInit();
            loadPropertyImg();
            loadXmlData();
        }


    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        string errMsg;
        int errCode;
        string _sql;
        string _getIdsql;
        string _ex;
        string _askingPrice;
        string _rentPrice;
        string _NoOfBedRoom = "0";
        string _NoOfBathRoom ="0";
        dbConn objConn = new dbConn();

        string location = WUCFT.selectedValue;
        _sql = "SELECT Loc_Group FROM tblPropLocation WHERE Loc_Code = '" + location + "'";

        string refcd = ddlPropertyCat.SelectedValue + objConn.ExecScalar(_sql, out errCode, out errMsg).ToString();
       

        _getIdsql = "SELECT IIf(IsNull(Max(Ref_Id)),0,Max(Ref_Id)) FROM tblPropListing WHERE Ref_Cd = '" + refcd + "'";
        int refid = objConn.getMax(_getIdsql, out errCode, out errMsg) + 1;

        if (cbExclusive.Checked)
        {
            _ex = "1";
        }
        else
        {
            _ex = "0";
        }

        if (cbThous.Checked)
        {
            _askingPrice = txtAskingPrice.Text + "000";
        }
        else if (cbMil.Checked)
        {
            _askingPrice = txtAskingPrice.Text + "000000";
        }
        else
        {
            _askingPrice = txtAskingPrice.Text;
        }

        if (cbThousRenting.Checked)
            _rentPrice = txtRentingPrice.Text + "000";
        else
            _rentPrice = txtRentingPrice.Text;


        string appstatus;
        if (Session["user_accesslevel"].ToString() == "1")
        {
            appstatus = "1";
        }
        else
        {
            appstatus = "2";
        }

        if (refcd.StartsWith("S"))
        {
            _NoOfBedRoom = txtBoxAppNoBedroom.Text;
            _NoOfBathRoom = txtBoxAppNoBathroom.Text;
        }
        else if (refcd.StartsWith("L"))
        {
            _NoOfBedRoom = txtBoxLandedNoBedroom.Text;
            _NoOfBathRoom = txtBoxLandedNoBathroom.Text;
        }

        string leaseYear = string.IsNullOrEmpty(txtLeaseHoldYear.Text)? "0" : txtLeaseHoldYear.Text;
        string ExpiredDate = string.IsNullOrEmpty(txtExpiredYear.Text) ? "0" : txtLeaseHoldYear.Text;
     
      

        _sql = "INSERT INTO tblPropListing(Ref_Cd, Ref_Id, AppRefPID, location, PropertyCode, PropertyType, BuiltUp_Area, Land_Area, PropertySpec, " +
               "PropertyCondition, FurnishedCondition, Tenure, TYear, ExpiredDate, NoOfBedRoom, NoOfBathRoom, AskingPrice, RentingPrice, Exclusive, PDesc, InsBy, PStatus) VALUES " +
               "('" + refcd + "'" + "," + "'" + refid.ToString() + "'" + "," + "'" + txtEAppPropRefID.Text + "'" + "," +
               "'" + location + "'" + "," +
               "'" + txtrdProjName.Text + "'" + "," +
               "'" + ddlPropType.SelectedValue + "'" + "," + "'" + txtBuiltUpArea.Text + "'" + "," +
               "'" + txtLandArea.Text + "'" + "," + "'" + ddlLandedStorey.SelectedValue + "'" + "," +
               "'" + rdBtnListPropCond.SelectedValue + "'" + "," +
               "'" + rdBtnListFurCond.SelectedValue + "'" + "," +
               "'" + rdBtnListTenure.SelectedValue + "'" + "," +
               "'" + leaseYear + "'" + "," +
               "'" + ExpiredDate + "'" + "," +
               _NoOfBedRoom + "," +  _NoOfBathRoom +  "," +
               "'" + _askingPrice + "'" + "," +
               "'" + _rentPrice + "'" + "," + "'" + _ex + "'" + "," +
               "'" + txtDesc.Text.Replace("'","''") + "'" + "," +
              // String.Format("{0:yyyy/MM/dd}", DateTime.Today) + "," +
               Session["user_id"].ToString() + "," + appstatus + ")"; 
             


        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg + "(" + refcd + refid.ToString() + ")";
        }
        else
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Blue;
            lblSysErrMsg.Text = "New Listing has been added successfully";
            pageMode(EDIT_MODE, refcd + refid.ToString());
        }
    }

    protected void btnUpdate_Click(object sender, EventArgs e)
    {
        dbConn objConn = new dbConn();
        string _sql;
        int errCode;
        string errMsg;
        int _ex;
        string _NoOfBedRoom = "0";
        string _NoOfBathRoom ="0";

        if (cbExclusive.Checked)
        {
            _ex = 1;
        }
        else
        {
            _ex = 0;
        }

        if (lblPropertyID.Text.StartsWith("S"))
        {
            _NoOfBedRoom = txtBoxAppNoBedroom.Text; 
            _NoOfBathRoom = txtBoxAppNoBathroom.Text;
        }
        else if (lblPropertyID.Text.StartsWith("L"))
        {
            _NoOfBedRoom = txtBoxLandedNoBedroom.Text;
            _NoOfBathRoom = txtBoxLandedNoBathroom.Text;
        }


        _sql = "UPDATE tblPropListing SET AskingPrice = '" + txtAskingPrice.Text + "', " +
               "RentingPrice = '" + txtRentingPrice.Text + "'," +
               "NoOfBedRoom = '" + _NoOfBedRoom + "'," +
               "NoOfBathRoom = '" + _NoOfBathRoom + "', " +
               "Tenure = '" + rdBtnListTenure.SelectedValue + "', " +
               "BuiltUp_Area = '" + txtBuiltUpArea.Text + "', " +
               "Exclusive = '" + _ex.ToString() + "', " +
               "PropertyCode = '" + txtrdProjName.Text + "', " +
               "Land_Area = '" + txtLandArea.Text + "'" +
               "WHERE Ref_Cd & Ref_Id = '" + lblPropertyID.Text + "'";

        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Blue;
            lblSysErrMsg.Text = "Listing has been update successfully";
            pageMode(EDIT_MODE, lblPropertyID.Text);
        }
        
    }

    protected void btnUpload_Click(object sender, EventArgs e)
    {
        string sql;

        const string ORIGIN_PATHNAME = "Gallery/Property/";
        const string NORMAL_THUMBNAIL_PATHNAME = "Gallery/Thumbnail/";
        const string EXCLUSIVE_THUMBNAIL_PATHNAME = "Gallery/ThumbnailEX/";

        dbConn objConn = new dbConn();
        string propId = lblPropertyID.Text;
        string refcd = propId.Substring(0, 2);
        string refid = propId.Substring(2, propId.Length - 2);
        string errMsg;
        int errCode;
        int rndFileName;
        int profilePic = 0;

        if (!String.IsNullOrEmpty(lblPropertyID.Text.Trim()))
        {
            if (UploadFile.HasFile)
            {
                HttpPostedFile upfile = UploadFile.PostedFile;
                int fileLength = upfile.ContentLength;
                int fileSize = fileLength / 1024;

                // -- Initialize system settings
                XmlDocument doc = new XmlDocument();
                doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));
                XmlNode root = doc.DocumentElement;
                string ImgFileSize = root.SelectSingleNode("ImgFileSize").ChildNodes[0].Value;


                    if (fileSize > Convert.ToInt16(ImgFileSize))
                    {
                        lblMsg.Text = "Image File size exceed limit. Should be less than " + ImgFileSize;
                    }
                    else
                    {

                        #region Image Process
                        try
                        {
                            Random rnd = new Random();
                            rndFileName = rnd.Next(1000, 9999);
                            //UploadFile.PostedFile.ContentLength
                            byte[] fileBytes = new byte[UploadFile.PostedFile.ContentLength];
                            // fill in byte array 
                            using (System.IO.Stream stream = UploadFile.PostedFile.InputStream)
                            {
                                stream.Read(fileBytes, 0, UploadFile.PostedFile.ContentLength);
                            }

                            string uploadFileName = DateTime.Now.Second.ToString() + DateTime.Now.Millisecond.ToString() + rndFileName + "." + GetExtension(UploadFile.FileName);
                            string ImgPath = ORIGIN_PATHNAME + uploadFileName;
                            string ThumbPath = NORMAL_THUMBNAIL_PATHNAME + uploadFileName;
                            string ThumbPath2 = EXCLUSIVE_THUMBNAIL_PATHNAME + uploadFileName;

                            // Save a origin copy first, in order to do thumbnail generation
                            //UploadFile.SaveAs(MapPath(ORIGIN_PATHNAME + uploadFileName));

                            ImgSize _Img = new ImgSize();

                            _Img._Height = 400;
                            _Img._Width = 400;


                            #region get System Settings Data

                            XmlNodeList objListImg = root.SelectNodes("ImageSize");
                            string ThumbNailSize = objListImg.Item(0)["ThumbNailSize"].InnerText;
                            string ThumbNailExSize = objListImg.Item(0)["ThumbNailSizeEx"].InnerText;
                            string Watermark = root.SelectSingleNode("Watermark").ChildNodes[0].Value;

                            #endregion


                            System.IO.File.WriteAllBytes(Server.MapPath(ORIGIN_PATHNAME + uploadFileName), ReSizeImageFile(fileBytes, _Img, Watermark));

                            System.Drawing.Image img1 = System.Drawing.Image.FromFile(MapPath(ORIGIN_PATHNAME) + uploadFileName);

                            decimal h = img1.Height;
                            decimal w = img1.Width;
                            ImgSize _ThumbImg = new ImgSize();
                            ImgSize _ThumbExImg = new ImgSize();
                            _ThumbImg = thumbnailCal(h, w, int.Parse(ThumbNailSize));
                            _ThumbExImg = thumbnailCal(h, w, int.Parse(ThumbNailExSize));

                            System.Drawing.Image bmp1 = img1.GetThumbnailImage(_ThumbImg._Width, _ThumbImg._Height, null, IntPtr.Zero);

                            System.Drawing.Image bmp2 = img1.GetThumbnailImage(_ThumbExImg._Width, _ThumbExImg._Height, null, IntPtr.Zero);

                            bmp1.Save(MapPath(NORMAL_THUMBNAIL_PATHNAME + uploadFileName));

                            if (cbExclusive.Checked)
                            {
                                bmp2.Save(MapPath(EXCLUSIVE_THUMBNAIL_PATHNAME + uploadFileName));
                                bmp2.Dispose();
                            }
                            else
                            {
                                ThumbPath2 = "";
                            }

                            img1.Dispose();
                            bmp1.Dispose();

                            if (cbProfilePicture.Checked)
                            {
                                profilePic = 1;
                            }


                            sql = "INSERT INTO tblPropImage(Ref_Cd, Ref_Id, ImageFileName, ImageFileDesc, ImageFileLocation, " +
                                  "ImageThumbNailLocation_1, ImageThumbNailLocation_2, ImageProfilePic, ImageActive) VALUES ('" + refcd + "'" + "," + "'" + refid + "'" + "," +
                                  "'" + txtbImageName.Text + "'" + "," + "'" + txtbImageDesc.Text + "'" + "," + "'" + ImgPath + "'" + "," +
                                  "'" + ThumbPath + "'" + "," + "'" + ThumbPath2 + "'" + "," + "'" + profilePic + "'" + "," + '1' + ")";


                            objConn.ExecSQL(sql, out errCode, out errMsg);

                            if (errCode == -1)
                            {
                                lblMsg.ForeColor = System.Drawing.Color.Red;
                                lblMsg.Text = errMsg;
                            }
                            else
                            {
                                lblMsg.ForeColor = System.Drawing.Color.Blue;
                                lblMsg.Text = "Photo upload successfully";
                            }

                            txtbImageName.Text = "";
                            txtbImageDesc.Text = "";
                            cbProfilePicture.Checked = false;

                            loadPropertyImg();

                        }
                        catch (Exception ex)
                        {
                            lblMsg.Text = ex.Message.ToString();
                        }
                        #endregion

                    }


            }
        }
    }





    protected void rpImage_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        if (e.CommandName == "EditImage")
        {
            Response.Redirect("ManagePropertyProfile.aspx?PID=" + lblPropertyID.Text);
        }
      
    }

    private void LisitngOp(string tranCode)
    {
        dbConn objConn = new dbConn();
        string _sql;
        int errCode;
        string errMsg;

        //_sql = "UPDATE tblPropListing SET PStatus = '" + tranCode + "', PStatusDate =" + String.Format("{0:yyyy/MM/dd}", DateTime.Today) +
        //       " WHERE Ref_Cd & Ref_Id = '" + lblPropertyID.Text + "'";

        _sql = "UPDATE tblPropListing SET PStatus = '" + tranCode + "'" +
               " WHERE Ref_Cd & Ref_Id = '" + lblPropertyID.Text + "'";

        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            Response.Redirect("PropListing.aspx");
        }
    }

    protected void btnDelete_Click(object sender, EventArgs e)
    {
        dbConn objConn = new dbConn();
        string _sql;
        int errCode;
        string errMsg;

        _sql = "UPDATE tblPropListing SET PActive = 2 " +
               " WHERE Ref_Cd & Ref_Id = '" + lblPropertyID.Text + "'";

        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            Response.Redirect("PropListing.aspx");
        }
    }

    protected void btnRented_Click(object sender, EventArgs e)
    {
        LisitngOp(Convert.ToInt16(CUtil.listingState.Rented).ToString());
    }

    protected void btnSold_Click(object sender, EventArgs e)
    {
        LisitngOp(Convert.ToInt16(CUtil.listingState.Sold).ToString());
    }
}
