using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.IO;


// once upload, system will save 3 files into server
// 1. origin file into Gallery\Property
// 2. Thumbnail exclusive 100 x 100 into 


// Property ID
// First character : [L], [S], [C]
// Second character : location group
// Third and forth : number
 
public partial class ImageUploadingPart : System.Web.UI.Page
{

    public const int EDIT_MODE = 1;
    public const int NEW_MODE = 2;

    public struct ImgSize
    {
        public int _Width;
        public int _Height;

    }

    public ImgSize thumbnailCal(decimal _h, decimal _w, int _size)
    {
        int thumbHeight;
        int thumbWidth;

        ImgSize _imgS = new ImgSize();

        if (_h > _w)
        {
            thumbHeight = _size;
            decimal tWidth = (_w / _h) * thumbHeight;
            thumbWidth = Convert.ToInt32(tWidth);
        }
        else
        {
            thumbWidth = _size;
            decimal tHeight = (_h / _w) * thumbWidth;
            thumbHeight = Convert.ToInt32(tHeight);
        }

        _imgS._Height = thumbHeight;
        _imgS._Width = thumbWidth;

        return _imgS;

        
    }


    public void loadPropertyImg()
    {
          dbConn objConn = new dbConn();
          int errCode;
          string errMsg;

          string _sql;
          string LID = lblPropertyID.Text;

          _sql = "SELECT ImageFileName, ImageThumbNailLocation_1, ImageProfilePic FROM tblPropImage WHERE " +
                 "Ref_Cd & Ref_Id = '" + LID + "'";  
                
          DataTable mDt = new DataTable();

          mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

          rpImage.DataSource = mDt;
          rpImage.DataBind();
    }

    public void loadSelectionData()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string _sql = "SELECT ID, PropertyDesc FROM tblPropType";
        DataTable mDt = new DataTable();
        DataTable mDt2 = new DataTable();

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        //if (errCode == 0)
        //{
        //     mDt.Rows.Add(new object[] { 0, "Please Select" });

        //     ddlPropType.DataSource = mDt;
        //     ddlPropType.DataTextField = "PropertyDesc";
        //     ddlPropType.DataValueField = "ID";
        //     ddlPropType.DataBind();
        //     ddlPropType.SelectedValue = "0";
        //}
        //else
        //{
        //    lblSysErrMsg.Text = errMsg;
        //    return;
           
        //}

        _sql = "SELECT Loc_Code AS LOCCode, Loc_Name FROM tblPropLocation";
        mDt2 = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        if (errCode == 0){
              
             mDt2.Rows.Add(new object[] { 0, "Please Select" });
             ddlLocation.DataSource = mDt2;
             ddlLocation.DataTextField = "Loc_Name";
             ddlLocation.DataValueField = "LOCCode";
             ddlLocation.DataBind();
             ddlLocation.SelectedValue = "0";
        }
        else{
            lblSysErrMsg.Text = errMsg;
            return;
           
        }

    }

    public void pageMode(int _mode, string _PID)
    {
        if (_mode == EDIT_MODE)
        {
            dbConn objConn = new dbConn();
            int errCode;
            string errMsg;
            DataTable mDt = new DataTable();

            btnSave.Visible = false;
            btnUpdate.Visible = true;
            string askingPrice;

            string _sql = "SELECT L.location, L.PropertyCode, L.PropertyType, L.BuiltUp_Area, L.Land_Area, " +
                          "L.PropertyCondition, L.Tenure, L.NoOfBedRoom, L.NoOfBathRoom, L.Exclusive, " +
                          "L.AskingPrice, L.RentingPrice, P.PropertyTypeDesc " +
                          "FROM tblPropListing L INNER JOIN tblPropName P ON L.PropertyCode = P.PID " +
                          "WHERE Ref_Cd & Ref_Id = '" + _PID + "'";

            mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

            if (errCode == 0)
            {

                DataRow DR;
                DR = mDt.Rows[0];
                lblPropertyID.Text = _PID;

                // None editable
                ddlPropertyCat.SelectedValue = _PID.Substring(0, 1);
                ddlLocation.SelectedValue = DR["location"].ToString();
                ddlPropType.SelectedValue = DR["PropertyType"].ToString();

                ddlPropertyCat.Enabled = false;
                ddlLocation.Enabled = false;
                ddlPropType.Enabled = false;
                ddlrdProjName.Enabled = false;

                askingPrice = DR["AskingPrice"].ToString();

                if (askingPrice.Substring(askingPrice.Length - 3) == "000")
                {
                    cbThous.Checked = true;
                    txtAskingPrice.Text = askingPrice.Remove(askingPrice.Length - 3);
                }
                else
                {
                    cbThous.Checked = false;
                    txtAskingPrice.Text = askingPrice;
                }

                
              
                //cbThous.Enabled = false;

                if (DR["Exclusive"].ToString() == "1")
                {
                    cbExclusive.Checked = true;
                }
                else
                {
                    cbExclusive.Checked = false;
                }

                cbExclusive.Enabled = false;

                txtNoBathRoom.Text = DR["NoOfBathRoom"].ToString();
                txtNoBedRoom.Text = DR["NoOfBedRoom"].ToString();

              
                txtRentingPrice.Text = DR["RentingPrice"].ToString();

                rdBtnListTenure.SelectedValue = DR["Tenure"].ToString();
                rdBtnListPropCond.SelectedValue = DR["PropertyCondition"].ToString();

                txtLandArea.Text = DR["Land_Area"].ToString();
                txtBuiltUpArea.Text = DR["BuiltUp_Area"].ToString();

            }
            else
            {

                lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
                lblSysErrMsg.Text = errMsg;
            }



            // FILL In data
        }
        else
        {
            btnSave.Visible = true;
            btnUpdate.Visible = false;
        }
    }

    public void pageInit()
    {
        if (Request.QueryString["PID"] == null)
        {
       
            pageMode(NEW_MODE, "0");
        }
        else
        {
          
            pageMode(EDIT_MODE, Request.QueryString["PID"].ToString());
        }
    }

    public bool FnCast(string vi)
    {
        //if (vi == "1"
        bool rtn = (vi == "1")?true: false;
        return rtn;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            pageInit();
            loadPropertyImg();
            loadSelectionData(); 
        }
    }

    protected void page_Init(object sender, EventArgs e)
    {
        MyAccordion.FindControl("nothing");
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
     


    }


    private string GetExtension(string FileName)
    {
        string[] split = FileName.Split('.');
        string Extension = split[split.Length - 1];
        return Extension;
    }

    private string GetFileNameOnly(string FileName)
    {
        string[] split = FileName.Split('.');
        string Extension = split[0];
        return Extension;
    }







    protected void btnUpload_Click(object sender, EventArgs e)
    {
           string sql;

           const string ORIGIN_PATHNAME = "Gallery/Property/";
           const string NORMAL_THUMBNAIL_PATHNAME = "Gallery/Thumbnail/";
           const string EXCLUSIVE_THUMBNAIL_PATHNAME = "Gallery/ThumbnailEX/";

           dbConn objConn = new dbConn();
           string propId = lblPropertyID.Text;


           string refcd = propId.Substring(0, 2);
           string refid = propId.Substring(2, propId.Length - 2);

           string errMsg;
           int errCode;

           int rndFileName;
           int profilePic = 0;


           if (UploadFile.HasFile)
           {

               try
               {
                   Random rnd = new Random();
                   rndFileName = rnd.Next(1000, 9999);

                   byte[] fileBytes = new byte[UploadFile.PostedFile.ContentLength];

                   // fill in byte array 
                   using (System.IO.Stream stream = UploadFile.PostedFile.InputStream)
                   {
                       stream.Read(fileBytes, 0, UploadFile.PostedFile.ContentLength);
                   }

                   string uploadFileName = DateTime.Now.Second.ToString() + DateTime.Now.Millisecond.ToString() + rndFileName + "." + GetExtension(UploadFile.FileName); // UploadFile.FileName;

                   string ImgPath = ORIGIN_PATHNAME + uploadFileName;
                   string ThumbPath = NORMAL_THUMBNAIL_PATHNAME + uploadFileName;
                   string ThumbPath2 = EXCLUSIVE_THUMBNAIL_PATHNAME + uploadFileName;

                   // Save a origin copy first, in order to do thumbnail generation
                   //UploadFile.SaveAs(MapPath(ORIGIN_PATHNAME + uploadFileName));

                   ImgSize _Img = new ImgSize();
                   //Stream  _s = UploadFile

                   _Img._Height = 400;
                   _Img._Width = 400;

                   System.IO.File.WriteAllBytes(Server.MapPath(ORIGIN_PATHNAME + uploadFileName), ReSizeImageFile(fileBytes, _Img));

                   System.Drawing.Image img1 = System.Drawing.Image.FromFile(MapPath(ORIGIN_PATHNAME) + uploadFileName);

                   decimal h = img1.Height;
                   decimal w = img1.Width;
                   ImgSize _ThumbImg = new ImgSize();
                   ImgSize _ThumbExImg = new ImgSize();
                   _ThumbImg = thumbnailCal(h, w, int.Parse(txtbHeight.Text));
                   _ThumbExImg = thumbnailCal(h, w, int.Parse(txtbHeightEx.Text));

                   System.Drawing.Image bmp1 = img1.GetThumbnailImage(_ThumbImg._Height, _ThumbImg._Width, null, IntPtr.Zero);

                   System.Drawing.Image bmp2 = img1.GetThumbnailImage(_ThumbExImg._Height, _ThumbExImg._Width, null, IntPtr.Zero);

                   bmp1.Save(MapPath(NORMAL_THUMBNAIL_PATHNAME + uploadFileName));

                   if (cbExclusive.Checked)
                   {
                       bmp2.Save(MapPath(EXCLUSIVE_THUMBNAIL_PATHNAME + uploadFileName));
                       bmp2.Dispose();
                   }
                   else
                   {
                       ThumbPath2 = "";
                   }//

                   img1.Dispose();
                   bmp1.Dispose();

                   if (cbProfilePicture.Checked)
                   {
                       profilePic = 1;
                   }
                  

                   sql = "INSERT INTO tblPropImage(Ref_Cd, Ref_Id, ImageFileName, ImageFileDesc, ImageFileLocation, " +
                         "ImageThumbNailLocation_1, ImageThumbNailLocation_2, ImageProfilePic, ImageActive) VALUES ('" + refcd + "'" + "," + "'" + refid + "'" + "," +
                         "'" + txtbImageName.Text + "'" + "," + "'" + txtbImageDesc.Text + "'" + "," + "'" + ImgPath + "'" + "," +
                         "'" + ThumbPath + "'" + "," + "'" + ThumbPath2 + "'" + "," + "'" + profilePic + "'" + "," + '1' + ")";


                   objConn.ExecSQL(sql, out errCode, out errMsg);

                   if (errCode == -1)
                   {
                       lblMsg.ForeColor = System.Drawing.Color.Red;
                       lblMsg.Text = errMsg;
                   }
                   else
                   {
                       lblMsg.ForeColor = System.Drawing.Color.Blue;
                       lblMsg.Text = "Photo upload successfully";
                   }

                   txtbImageName.Text = "";
                   txtbImageDesc.Text = "";
                   cbProfilePicture.Checked = false;

                   loadPropertyImg();

               }
               catch (Exception ex)
               {
                   lblMsg.Text = ex.Message.ToString();
               }
           }
    }


    public byte[] ReSizeImageFile(byte[] imageFile, ImgSize _targetSize)
    {

        Font font = new Font("Arial", 22, FontStyle.Bold, GraphicsUnit.Pixel);
        Color color = Color.FromArgb(254, 254, 0, 80); 
        //Adds a black watermark with a low alpha value (almost transparent).
        //The pixel point to draw the watermark at (this example puts it at 100, 100 (x, y)).
        SolidBrush brush = new SolidBrush(color);

        MemoryStream ms = new MemoryStream(imageFile);

        using (System.Drawing.Image oldImage =
                    System.Drawing.Image.FromStream(ms))
        {
            Size newSize = CalculateDimensions(oldImage.Size, _targetSize);

            using (Bitmap newImage =
                new Bitmap(newSize.Width, newSize.Height, PixelFormat.Format24bppRgb))
            {
                using (Graphics canvas = Graphics.FromImage(newImage))
                {
                    canvas.SmoothingMode = SmoothingMode.AntiAlias;
                    canvas.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    canvas.PixelOffsetMode = PixelOffsetMode.HighQuality;

                    canvas.DrawImage(oldImage,
                        new Rectangle(new Point(0, 0), newSize));


                    int _X = newSize.Width / 2;
                    int _Y = newSize.Height / 2;

                    Point atPoint = new Point(_X, _Y);
                    StringFormat sf = new StringFormat();
                    sf.Alignment = StringAlignment.Center;
                    sf.LineAlignment = StringAlignment.Center;


                    // txtbWatermark.Text

                    canvas.DrawString(txtbWatermark.Text, font, brush, atPoint, sf);

                    MemoryStream m = new MemoryStream();
                    newImage.Save(m, ImageFormat.Jpeg);
                    return m.GetBuffer();

                }

            }
        }
    }


    private Size CalculateDimensions(Size oldSize, ImgSize _ImgSize)
    {
        Size newSize = new Size();
        if (oldSize.Height > oldSize.Width)
        {
            newSize.Width = (int)(oldSize.Width * ((float)_ImgSize._Width / (float)oldSize.Height));
            newSize.Height = _ImgSize._Height;
        }
        else
        {
            newSize.Width = _ImgSize._Width;
            newSize.Height = (int)(oldSize.Height * ((float)_ImgSize._Height / (float)oldSize.Width));
        }
        return newSize;
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        string errMsg;
        int errCode;
        string _sql;
        string _getIdsql;
        string _ex;
        string _askingPrice;

        dbConn objConn = new dbConn();

        _sql = "SELECT Loc_Group FROM tblPropLocation WHERE Loc_Code = '" + ddlLocation.SelectedValue + "'";

        string refcd = ddlPropertyCat.SelectedValue + objConn.ExecScalar(_sql, out errCode, out errMsg).ToString();
        string location = ddlLocation.SelectedValue;

        _getIdsql = "SELECT Ref_Id FROM tblPropListing WHERE Ref_Cd = '" + refcd + "'";
        int refid = objConn.getMax(_getIdsql, out errCode, out errMsg) + 1;

        if (cbExclusive.Checked)
        {
            _ex = "1";
        }
        else
        {
            _ex = "0";
        }

        if (cbThous.Checked)
        {
            _askingPrice = txtAskingPrice.Text + "000";
        }
        else
        {
            _askingPrice = txtAskingPrice.Text;
        }

        _sql = "INSERT INTO tblPropListing(Ref_Cd, Ref_Id, location, PropertyCode, PropertyType, BuiltUp_Area, Land_Area, " +
               "PropertyCondition, Tenure, NoOfBedRoom, NoOfBathRoom, AskingPrice, RentingPrice, Exclusive, InsDate, InsBy) VALUES " +
               "('" + refcd + "'" + "," + "'" + refid.ToString() + "'" + "," + "'" + location + "'" + "," +
               ddlrdProjName.SelectedValue + "," +
               "'" + ddlPropType.SelectedValue + "'" + "," + "'" + txtBuiltUpArea.Text + "'" + "," +
               "'" + txtLandArea.Text + "'" + "," + "'" + rdBtnListPropCond.SelectedValue + "'" + "," +
               "'" + rdBtnListTenure.SelectedValue + "'" + "," + "'" + txtNoBedRoom.Text + "'" + "," + "'" + txtNoBathRoom.Text + "'" + "," +
               "'" + _askingPrice + "'" + "," +
               "'" + txtRentingPrice.Text + "'" + "," + "'" + _ex + "'" + "," +
               String.Format("{0:yyyy/MM/dd}", DateTime.Today) + "," +
               "'1')";

   
        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Blue;
            lblSysErrMsg.Text = "New Listing has been added successfully";
            pageMode(EDIT_MODE, refcd + refid.ToString());
        }

    }

    protected void btnUpdate_Click(object sender, EventArgs e)
    {
        dbConn objConn = new dbConn();
        string _sql;
        int errCode;
        string errMsg;
        int _ex;
        
        if (cbExclusive.Checked)
        {
            _ex = 1;
        }
        else
        {
            _ex = 0;
        }

        _sql = "UPDATE tblPropListing SET AskingPrice = '" + txtAskingPrice.Text + "', " +
               "RentingPrice = '" + txtRentingPrice.Text + "'," +
               "NoOfBedRoom = '" + txtNoBedRoom.Text + "'," + 
               "NoOfBathRoom = '" + txtNoBathRoom.Text + "', " +
               "Tenure = '" + rdBtnListTenure.SelectedValue + "', " +
               "BuiltUp_Area = '" + txtBuiltUpArea.Text  + "', " +
               "Exclusive = '" + _ex.ToString() + "', " +
               "Land_Area = '" + txtLandArea.Text + "'" +
               "WHERE Ref_Cd & Ref_Id = '" + lblPropertyID .Text + "'";

        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Blue;
            lblSysErrMsg.Text = "Listing has been update successfully";
            pageMode(EDIT_MODE, lblPropertyID.Text);
        }

    }






}
