using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

public partial class ManageNewst : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        if (!Page.IsPostBack)
        {
            loadNews();
            Date5.Text = DateTime.Today.Date.ToShortDateString();
        }
    }

    private void setAchor()
    {
        StringBuilder sb = new StringBuilder();
        sb.Append("<script language='javascript'>");
        sb.Append("window.location.href='#acSelect'");
        sb.Append("</script>");

        //Page.ClientScript.RegisterClientScriptBlock(this.GetType(),
        //  "CallServer", sb.ToString());

    }


    private void loadNews()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        DataTable mDt = new DataTable();

        string sql = "SELECT ID, NewsTitle, NewsContent, NewsPosted, NewsDate FROM tblNews WHERE NewsActive = 1 Order By NewsDate DESC";

        mDt = objConn.GetDataReader2Dt(sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            gvNews.DataSource = mDt;
            gvNews.DataBind();
        }

    }
    protected void gvNews_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        dbConn objConn = new dbConn();
        int dataKey = Convert.ToInt32(gvNews.DataKeys[e.RowIndex].Values[0].ToString());
        int errCode;
        string errMsg;

        string sSQL = "UPDATE tblNews SET NewsActive=0 WHERE ID = " + dataKey.ToString();

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            loadNews();
            DVNews.DataSource = null;
            DVNews.DataBind();
        }
    }

    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string sSQL = "INSERT INTO tblNews (NewsTitle, NewsContent, Link, NewsPosted, NewsDate) VALUES " +
                      "('" + txtNewsTitle.Text.Replace("'", "''") + "'" + "," + "'" + txtBoxContent.Text + "'" + "," +
                      "'" + txtLink.Text + "'" + "," +
                      "'" + txtPostedFrom.Text + "'"  + "," +
                      "'" + Date5.Text + 
                      "')";

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            loadNews();
        }

        clear();
    }

    protected void gvNews_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        dbConn _conn = new dbConn();
        int errCode;
        string errMsg;
        int dataKey = Convert.ToInt32(gvNews.DataKeys[e.NewSelectedIndex].Values[0].ToString());

        ViewState["NewsID"] = dataKey;
        string sSQL = "SELECT * FROM tblNews WHERE ID = " + dataKey.ToString();


        tblDetails.Visible = true;

        DVNews.DataSource = _conn.GetDataReader2Dt(sSQL, out errCode, out errMsg);
        DVNews.DataBind();

        setAchor();

    }


    private void loadDetails()
    {
        dbConn _conn = new dbConn();
        int errCode;
        string errMsg;

        string sSQL = "SELECT * FROM tblNews WHERE ID = " + Convert.ToInt32(ViewState["NewsID"].ToString());

        DVNews.DataSource = _conn.GetDataReader2Dt(sSQL, out errCode, out errMsg);
        DVNews.DataBind();
    }

    protected void DVNews_ModeChanging(object sender, DetailsViewModeEventArgs e)
    {
        switch (e.NewMode)
        {
            case DetailsViewMode.Edit:
                setAchor();
                DVNews.ChangeMode(DetailsViewMode.Edit);
                break;

            case DetailsViewMode.ReadOnly:
                DVNews.ChangeMode(DetailsViewMode.ReadOnly);
                break;
        }

        loadDetails();
    }

    protected void DVNews_ItemUpdating(object sender, DetailsViewUpdateEventArgs e)
    {
        dbConn _conn = new dbConn();

        int errCode;
        string errMsg;

        int NewsID = int.Parse(DVNews.DataKey[0].ToString());
        string AnnSub = Convert.ToString(((TextBox)(DVNews.Rows[0].FindControl("txtbEditSubject"))).Text);
        string AnnContent = Convert.ToString(((TextBox)(DVNews.Rows[0].FindControl("txtbEditContent"))).Text);

        string sSQL = "UPDATE tblNews SET NewsTitle ='" + AnnSub + "' , NewsContent = '" + AnnContent + "' " +
                      "WHERE ID = " + NewsID;


        _conn.ExecSQL(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            DVNews.ChangeMode(DetailsViewMode.ReadOnly);
            loadNews();
        }
    }



    protected void btnCancel_Click(object sender, EventArgs e)
    {
        clear();
    }

    #region Method

    private void clear()
    {
        txtNewsTitle.Text = string.Empty;
        txtBoxContent.Text = string.Empty;
        txtPostedFrom.Text = string.Empty;
        txtLink.Text = string.Empty;
    }


    #endregion
}
