using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ManagePropertyProfile : System.Web.UI.Page
{
   


    public void loadImgList(string PID)
    {
          dbConn objConn = new dbConn();
          int errCode;
          string errMsg;
          DataTable mDt = new DataTable();

          // Check number of primary photo has been set
          string _priSql = "SELECT COUNT(*) FROM tblPropImage WHERE " +
                           "Ref_cd & Ref_Id = '" + PID + "' AND ImageActive = 1 AND " +
                           "ImageProfilePic = 1";

           int numofPriPhoto = 0;
           numofPriPhoto = Convert.ToInt32(objConn.ExecScalar(_priSql, out errCode, out errMsg));

          if (errCode == -1)
          {
            lblMsg.ForeColor = System.Drawing.Color.Red;
            lblMsg.Text = errMsg;
            return;
          }
          else
          {
              if (numofPriPhoto > 1)
              {
                  DisplayMsg.Visible = true;
                  lblInfo.Text = "There is more than one picture set as primary photo. Please always maintain each property has only one primary photo.";
              }
              else if (numofPriPhoto == 0)
              {
                  DisplayMsg.Visible = true;
                  lblInfo.Text = "There is no photo set as primary photo. Please always maintain each property has only one primary photo.";
              }
              else
              {
                  DisplayMsg.Visible = false;
              }
          }
          

          string _sql = "SELECT ImageAutoID, Ref_cd & Ref_Id As PID, ImageFileName, ImageFileDesc, " +
                        "ImageFileLocation, ImageProfilePic, ImageThumbNailLocation_1 FROM tblPropImage WHERE " +
                        "ImageActive = 1 AND Ref_cd & Ref_Id = '" + PID + "'";

          mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

          DLImageList.DataSource = mDt;
          DLImageList.DataBind();
                
    }


    // Session["SelfEdit"]

    protected void Page_Unload(object sender, System.EventArgs e)
    {
        //Session["SelfEdit"]
       Session.Remove("SelfEdit");
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

       

        if (!Page.IsPostBack)
        {
            if (Request.QueryString["PID"] != null)
            {
                lblPID.Text = Request.QueryString["PID"].ToString();
                loadImgList(Request.QueryString["PID"].ToString());

                ViewState["PID"] = Request.QueryString["PID"].ToString();
            }
        }
    }


    protected void DLImageList_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int dataKey = Convert.ToInt32(DLImageList.DataKeys[e.Item.ItemIndex].ToString());
        int errCode;
        string errMsg;
        dbConn objConn = new dbConn();

        string sSQL = "DELETE FROM tblPropImage WHERE ImageAutoID = " + dataKey.ToString();

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblMsg.ForeColor = System.Drawing.Color.Red;
            lblMsg.Text = errMsg;
        }
        else
        {
            lblMsg.ForeColor = System.Drawing.Color.Blue;
            lblMsg.Text = "Delete successfully !!!";
            loadImgList(lblPID.Text);
        } 
    }

    protected void DLImageList_CancelCommand(object source, DataListCommandEventArgs e)
    {
        // Control back to initial read only mode
        DLImageList.EditItemIndex = -1;
        loadImgList(lblPID.Text);
    }

    protected void DLImageList_EditCommand(object source, DataListCommandEventArgs e)
    {
        DLImageList.EditItemIndex = e.Item.ItemIndex;
        loadImgList(lblPID.Text);
    }

    protected void DLImageList_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int dataKey = Convert.ToInt32(DLImageList.DataKeys[e.Item.ItemIndex].ToString());
        int errCode;
        string errMsg;
        dbConn objConn = new dbConn();
        string _pri = "0";

        TextBox _Caption = (TextBox)e.Item.FindControl("txtBCaption");
        TextBox _Desc = (TextBox)e.Item.FindControl("txtBDesc");
        CheckBox _rbtn = (CheckBox)e.Item.FindControl("ckbSetPrimary");

        if (_rbtn.Checked)
        {
            _pri = "1";
        }
        

        string _sql = "UPDATE tblPropImage SET ImageFileName = '" + _Caption.Text + "', ImageFileDesc = '" + _Desc.Text + "', " +
                      "ImageProfilePic = " +  _pri  +
                      " WHERE ImageAutoID =" + dataKey.ToString();

        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblMsg.ForeColor = System.Drawing.Color.Red;
            lblMsg.Text = errMsg;
        }
        else
        {
            lblMsg.ForeColor = System.Drawing.Color.Blue;
            lblMsg.Text = "Update successfully !!!";
        }

        DLImageList.EditItemIndex = -1;
        loadImgList(lblPID.Text);

        
    }
    protected void DLImageList_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item ||
            e.Item.ItemType == ListItemType.AlternatingItem)
        {
            DataRowView drv = (DataRowView)(e.Item.DataItem);

            if (drv.Row["ImageProfilePic"].ToString() == "1")
            {
                Literal lit;
                lit = (Literal)e.Item.FindControl("ltPrimary");
                lit.Text = "<p>Primary</p>";
            }
        }

        if (e.Item.ItemType == ListItemType.EditItem)
        {
             DataRowView drv = (DataRowView)(e.Item.DataItem);

             if (drv.Row["ImageProfilePic"].ToString() == "1")
             {
                 CheckBox _rbtn = (CheckBox)e.Item.FindControl("ckbSetPrimary");
                 _rbtn.Checked = true;
             }
        }
        
    }
    protected void ImgBtnBackToListing_Click(object sender, ImageClickEventArgs e)
    {

    }
    protected void ImgBtnBackButton_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect("managePropertyListing.aspx?PID=" + ViewState["PID"].ToString());
    }
}
