using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ManageUserPage : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        if (!Page.IsPostBack)
        {
            loadUserDetails();
        }
    }

    public void loadUserDetails()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        DataTable mDt = new DataTable();

        string _sql = "SELECT * FROM tblPropUser WHERE user_active = 1";


        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);


        gvUser.DataSource = mDt;
        gvUser.DataBind();
    }
    protected void gvUser_RowEditing(object sender, GridViewEditEventArgs e)
    {
        gvUser.ShowFooter = false;
        gvUser.EditIndex = e.NewEditIndex;
        loadUserDetails();
    }

    protected void gvUser_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        gvUser.ShowFooter = true;
        gvUser.EditIndex = -1;
        loadUserDetails();
    }

    protected void gvUser_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        int dataKey = Convert.ToInt32(gvUser.DataKeys[e.RowIndex].Values[0].ToString());

        string sSQL = "UPDATE tblPropUser SET user_active =0 WHERE ID = " + dataKey.ToString();

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

           if (errCode == -1)
           {
               lblSysErrMsg.Text = errMsg;
           }
           else
           {
               loadUserDetails();
           }
    }
    protected void gvUser_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        int dataKey = Convert.ToInt32(gvUser.DataKeys[e.RowIndex].Values[0].ToString());

        TextBox _UserName = (TextBox)gvUser.Rows[e.RowIndex].FindControl("txtBUserName");
        TextBox _PassWord = (TextBox)gvUser.Rows[e.RowIndex].FindControl("txtBUserPassword");
        DropDownList _DDL = (DropDownList)gvUser.Rows[e.RowIndex].FindControl("ddlUserAccessLevel");

        string sSQL = "UPDATE tblPropUser SET user_name = '" + _UserName.Text + "', " +
                      " user_password = '" + _PassWord.Text + "', " +
                      " user_accesslevel = '" + _DDL.SelectedValue + "' " + 
                      "WHERE ID = " + dataKey.ToString();

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

        gvUser.EditIndex = -1;

        if (errCode == -1)
        {
            lblSysErrMsg.Text = errMsg;
            gvUser.ShowFooter = true;
            gvUser.EditIndex = -1;
        }
        else
        {
            gvUser.ShowFooter = true;
            gvUser.EditIndex = -1;
            loadUserDetails();
        }

  
     

    }




    protected void gvUser_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        // || e.Row.RowType == DataControlRowType.EmptyDataRow
        if (e.Row.RowType == DataControlRowType.DataRow)
        {

            DataRowView drv = (DataRowView)(e.Row.DataItem);
            string user_accesslevel = drv["user_accesslevel"].ToString();

            Label lbl = (Label)e.Row.FindControl("lblUserAccessLevel");

            if (lbl != null)
            {
                if (user_accesslevel == "1")
                {
                    lbl.Text = "Supper Admin";
                }
                else if (user_accesslevel == "2")
                {
                    lbl.Text = "Normal";
                }
                else if (user_accesslevel == "3")
                {
                    lbl.Text = "Admin";
                }
            }
         
            
            DropDownList ddl = (DropDownList)e.Row.FindControl("ddlUserAccessLevel");

            if (ddl != null)
            {
                ddl.SelectedValue = user_accesslevel;
            }
       
            
        }

        

         
    }
    protected void gvUser_RowCreated(object sender, GridViewRowEventArgs e)
    {
        
    }
    protected void gvUser_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Insert")
        {

            dbConn objConn = new dbConn();
            int errCode;
            string errMsg;


            TextBox _UserName = (TextBox)gvUser.FooterRow.FindControl("txtInsUserName");
            TextBox _PassWord = (TextBox)gvUser.FooterRow.FindControl("txtInsUserPassword");
            DropDownList _DDL = (DropDownList)gvUser.FooterRow.FindControl("ddlInsUserAccessLevel");


            string sSQL = "INSERT INTO tblPropUser(user_name, user_password, user_accesslevel) " +
                          "VALUES " +
                          "('" + _UserName.Text + "'" + "," + "'" + _PassWord.Text + "'" + "," +
                          "'" + _DDL.SelectedValue + "')";

            objConn.ExecSQL(sSQL, out errCode, out errMsg);

            if (errCode == -1)
            {
          
                lblSysErrMsg.Text = errMsg;
            }
            else
            {
     
                loadUserDetails();
            }
        }
    }
}
