using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class PropListing : System.Web.UI.Page
{
    #region event
    protected void usrCtrlSearchClickHere(object sender, EventArgs e)
    {
        loadListing();
    }
    #endregion


    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        WUCFT.usrCtrlSearchClick += new EventHandler(usrCtrlSearchClickHere);

        if (!Page.IsPostBack)
        {
            WUCFT.intialValue = "1000";
            WUCFT.location = "0";
            loadListing();
        }
    }




    private void loadListing()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        DataTable mDt = new DataTable();

        string _sql = "SELECT Ref_Cd & Ref_Id AS PID, P.AppRefPID, P.PropertyCode, P.PropertyType,  " +
                      "P.PropertyCondition, P.FurnishedCondition, P.Tenure, L.Loc_Name, T.PropertyDesc, " +
                      "P.AskingPrice, P.RentingPrice, P.Exclusive, P.PStatus, U.user_name FROM " +
                      "((tblPropListing P INNER JOIN " +
                      "tblPropLocation L ON P.location = L.Loc_Code) INNER JOIN " +
                      "tblPropType T ON P.PropertyType = T.ID) " +
                      "INNER JOIN tblPropUser U ON P.InsBy = U.ID " + 
                      "WHERE PActive <> 2 ";

        // Precedence
        if (!string.IsNullOrEmpty(WUCFT.propertyID))
        {
            _sql = _sql + "AND Ref_Cd & Ref_Id = '" + WUCFT.propertyID.Trim() + "'";
        }
        else
        {

            if (WUCFT.PropertyTag == "Sales")
            { _sql = _sql + " AND P.AskingPrice <> 0 AND P.RentingPrice = 0"; }
            else if (WUCFT.PropertyTag == "ToLet")
            { _sql = _sql + " AND P.RentingPrice <> 0 AND P.AskingPrice = 0"; } 

            if (WUCFT.propCat != "0")
            {
                _sql = _sql + "AND LEFT(P.Ref_Cd, 1) = '" + WUCFT.propCat + "'";
            }

            if ((WUCFT.location != "0") && (!string.IsNullOrEmpty(WUCFT.location)))
            {
                _sql = _sql + "AND location = '" + WUCFT.location + "'";
            }

            if ((WUCFT.propTypeSelectedVal != "0") && (!string.IsNullOrEmpty(WUCFT.propTypeSelectedVal)))
            {
                _sql = _sql + "AND PropertyType = " + WUCFT.propTypeSelectedVal;
            }
        }

        // Filter by Normal user
        if (Session["user_accesslevel"].ToString() != "1")
        {
            _sql = _sql + "AND InsBy = " + Session["user_id"].ToString();
        }
       
        _sql = _sql + " ORDER BY InsDate ";

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        if (errCode == 0)
        {
     

            gvPropListing.DataSource = mDt;
            gvPropListing.DataBind();
        }
        else
        {
            lblMsg.Text = errMsg;
        }

    }

    protected void gvPropListing_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            CUtil outil = new CUtil();

            DataRowView drv = (DataRowView)(e.Row.DataItem);
            string AskingPrice = drv["AskingPrice"].ToString();
            string RentingPrice = drv["RentingPrice"].ToString();

            Label lblAskingPrice = (Label)e.Row.FindControl("lblSalesPrice");
            Label lblRentingPrice = (Label)e.Row.FindControl("lblRentPrice");

            if (lblAskingPrice != null)
            {
                lblAskingPrice.Text = "RM " + outil.factorPrice(AskingPrice);
                lblRentingPrice.Text = "RM " + outil.factorPrice(RentingPrice);
            }

            if (drv["PStatus"].ToString() == "2")
            {
                e.Row.BackColor = System.Drawing.Color.FromName("#CCFF00");
            }
            else if (drv["PStatus"].ToString() == "3")
            {
                e.Row.BackColor = System.Drawing.Color.FromName("#CCCCFF");
            }
        }
    }
    protected void gvPropListing_RowCreated(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
           // e.Row.
           // e.Row.Attributes.Add("onclick", "onGridViewRowSelected('" + m_iRowIdx.ToString() + "')");
        }

    }
    protected void gvPropListing_SelectedIndexChanged(object sender, EventArgs e)
    {
        
       // Response.Redirect("CRUDPropertyPage.aspx?PID=" + gvPropListing.SelectedDataKey.Value.ToString());
        Response.Redirect("managePropertyListing.aspx?PID=" + gvPropListing.SelectedDataKey.Value.ToString());
    
    }

    protected void gvPropListing_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
       
    }
    protected void gvPropListing_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvPropListing.PageIndex = e.NewPageIndex;
        loadListing();
    }
    protected void gvPropListing_PageIndexChanged(object sender, EventArgs e)
    {

    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        loadListing();
    }
    protected void gvPropListing_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        dbConn objConn = new dbConn();
        string dataKey = gvPropListing.DataKeys[e.RowIndex].Values[0].ToString();
        int errCode;
        string errMsg;

        string sSQL = "UPDATE tblPropListing SET PActive=" + Convert.ToInt16(CUtil.listingStatus.Delete) +
                      " WHERE Ref_Cd & Ref_Id = '" + dataKey.ToString() + "'";

        objConn.ExecSQL(sSQL, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblMsg.ForeColor = System.Drawing.Color.Red;
            lblMsg.Text = errMsg;
        }
        else
        {
            loadListing();
        }
    }

    protected void gvPropListing_RowDeleted(object sender, GridViewDeletedEventArgs e)
    {
   
    }
}
