using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class SysMonitorAlert : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        if (!Page.IsPostBack)
        {
            loadAlert();
        }
    }

    private void loadAlert()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string _sql;


       _sql = "SELECT Ref_Cd & Ref_Id AS PID FROM tblPropImage " +
              "WHERE ImageActive = 1 " +
              "GROUP BY Ref_Cd & Ref_Id, ImageProfilePic " +
              "HAVING COUNT(*)  > 1";

        DataTable mDt = new DataTable();

        DataTable myDataTable = new DataTable();

        DataColumn myDataColumn;

        myDataColumn = new DataColumn();
        myDataColumn.DataType = System.Type.GetType("System.String");
        myDataColumn.ColumnName = "Property_ID";
        myDataTable.Columns.Add(myDataColumn);

        myDataColumn = new DataColumn();
        myDataColumn.DataType = System.Type.GetType("System.String");
        myDataColumn.ColumnName = "Issue";
        myDataTable.Columns.Add(myDataColumn);

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        for (int i = 0; i < mDt.Rows.Count; i++)
        {
            DataRow myDataRow;
            myDataRow = myDataTable.NewRow();
            myDataRow["Property_ID"] = mDt.Rows[i]["PID"].ToString();
            myDataRow["Issue"] = "There are more than 2 photo set as primary, Please alwasy maintain it as one primary photo";
            myDataTable.Rows.Add(myDataRow);
        }

        _sql = "SELECT Ref_Cd & Ref_Id AS PID FROM tblPropImage AS P1 " +
               "WHERE ImageActive = 1 and ImageProfilePic = 0 " +
               "GROUP BY Ref_Cd & Ref_Id " +
               "HAVING COUNT(*) = " +
               "(Select COUNT(*) FROM  tblPropImage P2  WHERE P2.ImageActive = 1 " +
               "AND P2.Ref_Cd & P2.Ref_Id = P1.Ref_Cd & P1.Ref_Id " +
               "GROUP BY P2.Ref_Cd & P2.Ref_Id)";

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        for (int i = 0; i < mDt.Rows.Count; i++)
        {
            DataRow myDataRow;
            myDataRow = myDataTable.NewRow();
            myDataRow["Property_ID"] = mDt.Rows[i]["PID"].ToString();
            myDataRow["Issue"] = "Please set one of the photo as primary";
            myDataTable.Rows.Add(myDataRow);
        }

        rpSysMonitor.DataSource = myDataTable;
        rpSysMonitor.DataBind();
    }

    protected void rpSysMonitor_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        Label _propId = (Label)e.Item.FindControl("lblPropertyID");

        if (e.CommandName == "Todo")
            Response.Redirect("ManagePropertyProfile.aspx?PID=" + _propId.Text);

      
    }
}
