using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;

public partial class SystemSettings : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        if (!Page.IsPostBack)
        {
            LoadXmlDoc();
        }
    }

    public void LoadXmlDoc()
    {
        XmlDocument doc = new XmlDocument();
        doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));

        XmlNode root = doc.DocumentElement;
        txtExPhotoInSlideShow.Text = root.SelectSingleNode("NumOfExDispPhoto").ChildNodes[0].Value;
        txtWaterMark.Text = root.SelectSingleNode("Watermark").ChildNodes[0].Value;
        txtImgFileSize.Text = root.SelectSingleNode("ImgFileSize").ChildNodes[0].Value;
        txtSlideShowDelay.Text = root.SelectSingleNode("SlideShowDelay").ChildNodes[0].Value;
        txtSlideShowSpeed.Text = root.SelectSingleNode("SlideShowSpeed").ChildNodes[0].Value;
        txtBoxKeyWord.Text = root.SelectSingleNode("MetaKeyword").ChildNodes[0].Value;

        XmlNodeList objList = root.SelectNodes("NoOfDay");
        txtNoOfDayNewAttach.Text = objList.Item(0)["NewAttach"].InnerText;
        txtNoOfDaySoldAttach.Text = objList.Item(0)["SoldAttach"].InnerText;

        XmlNodeList objListImg = root.SelectNodes("ImageSize");
        txtThumbNailSize.Text = objListImg.Item(0)["ThumbNailSize"].InnerText;
        txtThumbNailSizeEx.Text = objListImg.Item(0)["ThumbNailSizeEx"].InnerText;

        XmlNodeList objEmailNotification = root.SelectNodes("EmailNotification");
        rdEmailNotification.SelectedValue = objEmailNotification.Item(0)["ListingApproval"].InnerText;

        txtEmailNotificationTo.Text = objEmailNotification.Item(0)["Receiving"].InnerText;

        XmlNodeList objListMail = root.SelectNodes("EmailInquiry");
        txtEmailFrom.Text = objListMail.Item(0)["From"].InnerText;
        txtEmailTo.Text = objListMail.Item(0)["To"].InnerText;
        txtEmailCc.Text = objListMail.Item(0)["Cc"].InnerText;
    }

    protected void BtnSave_Click(object sender, EventArgs e)
    {
         XmlDocument doc = new XmlDocument();
         doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));

         XmlNode root = doc.DocumentElement;
         XmlNodeList nodeList = doc.SelectNodes("NumOfExDispPhoto");

         root.SelectSingleNode("NumOfExDispPhoto").ChildNodes[0].Value = txtExPhotoInSlideShow.Text;
         root.SelectSingleNode("Watermark").ChildNodes[0].Value = txtWaterMark.Text;
         root.SelectSingleNode("ImgFileSize").ChildNodes[0].Value = txtImgFileSize.Text;
         root.SelectSingleNode("SlideShowSpeed").ChildNodes[0].Value = txtSlideShowSpeed.Text;
         root.SelectSingleNode("SlideShowDelay").ChildNodes[0].Value = txtSlideShowDelay.Text;

         XmlNodeList objEmailNotification = root.SelectNodes("EmailNotification");
         objEmailNotification.Item(0)["ListingApproval"].InnerText = rdEmailNotification.SelectedValue;

         objEmailNotification.Item(0)["Receiving"].InnerText = txtEmailNotificationTo.Text;

         XmlNodeList objList = root.SelectNodes("NoOfDay");
         objList.Item(0)["NewAttach"].InnerText = txtNoOfDayNewAttach.Text;
         objList.Item(0)["SoldAttach"].InnerText = txtNoOfDaySoldAttach.Text;

         XmlNodeList objListImg = root.SelectNodes("ImageSize");
         objListImg.Item(0)["ThumbNailSize"].InnerText = txtThumbNailSize.Text;
         objListImg.Item(0)["ThumbNailSizeEx"].InnerText = txtThumbNailSizeEx.Text;

         XmlNodeList objListMail = root.SelectNodes("EmailInquiry");
         objListMail.Item(0)["From"].InnerText = txtEmailFrom.Text;
         objListMail.Item(0)["To"].InnerText = txtEmailTo.Text;
         objListMail.Item(0)["Cc"].InnerText = txtEmailCc.Text;

      


        //txtSlideShowDelay

         doc.Save(Server.MapPath("App_Data/eliteSysConfig.xml"));
         LoadXmlDoc();

         //nodeList[0].ChildNodes[0].InnerText = "ASP.NET";
    }
    protected void btnSaveKey_Click(object sender, EventArgs e)
    {
        XmlDocument doc = new XmlDocument();
        doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));
        XmlNode root = doc.DocumentElement;
        root.SelectSingleNode("MetaKeyword").ChildNodes[0].Value = txtBoxKeyWord.Text;

        doc.Save(Server.MapPath("App_Data/eliteSysConfig.xml"));
    }

    protected void btnUpload_Click(object sender, EventArgs e)
    {
        XmlDocument doc = new XmlDocument();
        doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));
        XmlNode root = doc.DocumentElement;


        if (UploadFile.HasFile)
        {
            HttpPostedFile upfile = UploadFile.PostedFile;

            string strFileName = string.Empty;
            strFileName = UploadFile.PostedFile.FileName;

            System.Drawing.Image imgSize = System.Drawing.Image.FromStream(UploadFile.PostedFile.InputStream);



            if (imgSize.Width.ToString() == CUtil.CommonCode.ImageHeaderWidth)
            {
                try
                {
                    UploadFile.PostedFile.SaveAs(Server.MapPath(CUtil.CommonCode.ImageHeaderPath + strFileName));
                    XmlNodeList objList = root.SelectNodes("WebPhotoHeader");
                    objList.Item(0)["Path"].InnerText = CUtil.CommonCode.ImageHeaderPath + strFileName;
                    doc.Save(Server.MapPath("App_Data/eliteSysConfig.xml"));
                }
                catch
                {
                    lblMsg.Text = "File to Upload";
                }
            }
            else
            {
                lblMsg.Text = "Please ensure the photo header width is 930 px";
            }
        }
    }
}
