using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Data.OleDb;

public partial class ViewPropertyProfile : System.Web.UI.Page
{

    public struct ImgSize
    {
        public int _Width;
        public int _Height;

    }

    public ImgSize thumbnailCal(decimal _h, decimal _w, int _size)
    {
        int thumbHeight;
        int thumbWidth;

        ImgSize _imgS = new ImgSize();

        if (_h > _w)
        {
            thumbHeight = _size;
            decimal tWidth = (_w / _h) * thumbHeight;
            thumbWidth = Convert.ToInt32(tWidth);
        }
        else
        {
            thumbWidth = _size;
            decimal tHeight = (_h / _w) * thumbWidth;
            thumbHeight = Convert.ToInt32(tHeight);
        }

        _imgS._Height = thumbHeight;
        _imgS._Width = thumbWidth;

        return _imgS;


    }

    public void loadPropertyData(string _PID)
    {
        dbConn objConn = new dbConn();
        DataTable mDt = new DataTable();
        int errCode;
        string errMsg;

        string _sql = "SELECT P.Ref_Cd & P.Ref_Id AS PID, P.Location, P.AppRefPID, P.PropertyCode, P.NoOfBedRoom, P.NoOfBathRoom, " +
                      "P.PropertyType, P.PropertySpec, P.BuiltUp_Area, P.Land_Area, P.PropertyCondition, P.FurnishedCondition, P.Tenure, P.TYear, P.PDesc, " +
                      "P.AskingPrice, P.RentingPrice, P.Exclusive, L.Loc_Name, T.PropertyDesc, P.InsDate " +
                      "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.Location = L.Loc_Code) " +
                      "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
                      "WHERE P.Ref_Cd & P.Ref_Id = '" + _PID + "'";


        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);
        CUtil outil = new CUtil();

        if (errCode == 0)
        {
            DataRow DR;
            DR = mDt.Rows[0];
            tbLocation.Text = DR["Loc_Name"].ToString();
            tbBathroom.Text = DR["NoOfBathRoom"].ToString(); 
            tbBedroom.Text = DR["NoOfBedRoom"].ToString();
            lblPropCondition.Text = DR["PropertyCondition"].ToString();
            lblPropType.Text = DR["PropertyDesc"].ToString();
            lblProjRdName.Text = DR["PropertyCode"].ToString();
            lblInsDate.Text = String.Format("{0:dd/MMM/yyyy}", Convert.ToDateTime(DR["InsDate"]));
            lblLandArea.Text = DR["Land_Area"].ToString();
            lblBuiltUpArea.Text = DR["BuiltUp_Area"].ToString();
            //lblAskingPrice.Text = string.Format("{0:#,000}", Convert.ToInt32(DR["AskingPrice"]));
            //lblRentalPrice.Text = string.Format("{0:#,000}", Convert.ToInt32(DR["RentingPrice"]));

            lblAskingPrice.Text = outil.factorPrice(DR["AskingPrice"].ToString());
            lblRentalPrice.Text = outil.factorPrice(DR["RentingPrice"].ToString()) + " Per Month";

            lblFurnish.Text = DR["FurnishedCondition"].ToString();

            txtDesc.Text = DR["PDesc"].ToString();

            if (DR["PID"].ToString().StartsWith("S"))
            {
                lblFloor.Visible = true;
                lblFloor.Text = DR["PropertySpec"].ToString() + " Floor";
            }
            


            if (DR["Tenure"].ToString() == CUtil.tenureType.Leasehold.ToString())
            {
                lblTenure.Text = DR["Tenure"].ToString() + "    (" + DR["TYear"].ToString() + " years)";
            }
            else
            {
                lblTenure.Text = DR["Tenure"].ToString();
            }

            lblPropertyId.Text = DR["PID"].ToString();
            lblRefId.Text = DR["AppRefPID"].ToString();
          

          //  tbExclusive.Text = (DR["Exclusive"].ToString() == "1") ? "Yes" : "No";
        }
        else
        {
            lblSysErrMsg.Text = errMsg;
        }

    }

    public void loadPropertyImage(string _PID)
    {
        dbConn objConn = new dbConn();
        DataTable mDt = new DataTable();
        int errCode;
        string errMsg;

        string _sql = "SELECT Ref_Cd & Ref_Id AS PID, ImageFileName, ImageFileDesc, " +
                      "ImageFileLocation, ImageThumbNailLocation_1, ImageThumbNailLocation_2, " +
                      "ImageProfilePic, ImageActive " +
                      "FROM tblPropImage WHERE " +
                      "Ref_Cd & Ref_Id = '" + _PID + "' AND ImageActive=1 " +
                      "ORDER BY ImageProfilePic DESC";

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        if (errCode == 0)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append("<div class='image_thumb'>");
            builder.Append("<ul>");

            foreach (DataRow row in mDt.Rows)
            {
                if (row["ImageProfilePic"].ToString() == "1")
                {
                    imgFirstImg.ImageUrl = row["ImageFileLocation"].ToString();
                    LtDispInfo.Text = "<div class='block'>" +
                                      "<h2>" + row["ImageFileName"].ToString() + "</h2>" +
                                      "<small>" + row["ImageFileDesc"].ToString() + "</small>" +
                                      "<p>" + row["ImageFileDesc"].ToString()  + "</p></div>";
                }

                // thumbnailCal

                System.Drawing.Image img1 = System.Drawing.Image.FromFile(MapPath(row["ImageThumbNailLocation_1"].ToString()));
                decimal h = img1.Height;
                decimal w = img1.Width;
                ImgSize _ThumbImg = new ImgSize();
                _ThumbImg = thumbnailCal(h, w, 80);


                builder.Append("<li>");
                builder.Append("<a href='" + row["ImageFileLocation"].ToString() + "'>");
                builder.Append("<img  width='" + _ThumbImg._Width + "' height='" + _ThumbImg._Height + "' alt='Photo' src='" + row["ImageThumbNailLocation_1"].ToString() + "'>");
                builder.Append("</a>");
                builder.Append("<div class='block'>");
                builder.Append("<h2>" + row["ImageFileName"].ToString() + "</h2><small>" + row["ImageFileDesc"].ToString() + "</small>");
                builder.Append("<p>");
                builder.Append(row["ImageFileDesc"].ToString());
                builder.Append("<br>");
                builder.Append("</p>");
                builder.Append("</div>");
                builder.Append("</li>");

            }

            if (mDt.Rows.Count == 0)
            {
                imgFirstImg.ImageUrl = "Images/Item/nolistings.gif";
            }


            builder.Append("</ul>");
            builder.Append("</div>");

            ImgThumbNail.Text = builder.ToString();

        }
        else
        {
            lblSysErrMsg.Text = errMsg;
        }
    }


    protected void Page_Load(object sender, EventArgs e)
    {

        HtmlLink link = new HtmlLink();
        link.Href = "CSS/ImageGalleryStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        HtmlLink link2 = new HtmlLink();
        link2.Href = "CSS/mainContainerStyle.css";
        link2.Attributes.Add("rel", "stylesheet");
        link2.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link2);

        if (!Page.IsPostBack)
        {

            try
            {
          

                if (Request.QueryString["PID"] != null)
                {
                    string _propertyID = Request.QueryString["PID"].ToString();
                    loadPropertyData(_propertyID);
                    loadPropertyImage(_propertyID);
                }

                if ((Session["user_id"] == null) || (Session["user_id"].ToString() == ""))
                {
                    ImgBtn.Visible = false;
                }
                else
                {
                    ImgBtn.Visible = true;
                }

            }
            catch (Exception _ex)
            {
                Response.Write(_ex.ToString());
            }

            try
            {
                //generateImgThumbNail();
            }
            catch (Exception _ex)
            {
                Response.Write(_ex.ToString());
            }

        }

    }



    protected void ImgBtn_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect("managePropertyListing.aspx?PID=" + Request.QueryString["PID"].ToString());
    }
    protected void btnSend_Click(object sender, EventArgs e)
    {
        System.Web.Mail.MailMessage myMail = new System.Web.Mail.MailMessage();

        string pageURL = "http://" + Request.ServerVariables["SERVER_NAME"] + Request.ServerVariables["URL"] + "?" + Request.QueryString;

        myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/sendusing", 2);
        myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/smtpserver", "mail.eliteproperties.com.my");
        myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/smtpserverport", 25);

        myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate", "1");
        myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/sendusername", "guest@eliteproperties.com.my");
        myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/sendpassword", "q1w2e3");


        StringBuilder sb = new StringBuilder();
        sb.Append("Your friend " + txtBYourName.Text + " would like to show you an ad avaiable in eliteproperties.com.my");
        sb.Append("<p>Click the link to see the ad:</p>");
        sb.Append("<p>mailto:" + pageURL + "</p>");


        sb.Append("<br>");
        sb.Append(buildTemplate());


        myMail.From = "guest@eliteproperties.com.my";
        myMail.To = txtBYourFriendEmail.Text;

        myMail.Subject = "Enquiry Form";
        myMail.BodyFormat = System.Web.Mail.MailFormat.Html;
        myMail.Body = sb.ToString();


       System.Web.Mail.SmtpMail.SmtpServer = "mail.eliteproperties.com.my";
       System.Web.Mail.SmtpMail.Send(myMail);
    }

    protected void LinkButton1_Click(object sender, EventArgs e)
    {
     
    }

    protected void LBEnquiry_Click(object sender, EventArgs e)
    {
        Response.Redirect("ContactUs.aspx?LPID=" + lblPropertyId.Text);
    }
    protected void ImgBtn_Click1(object sender, ImageClickEventArgs e)
    {
        Response.Redirect("managePropertyListing.aspx?PID=" + Request.QueryString["PID"].ToString());
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        Response.Write("as");
    }

    private string buildTemplate()
    {
        StringBuilder builder = new StringBuilder();
        builder.Append("<table border='1' cellspacing='1' cellpadding='1' width='800px' ");
        builder.Append("style='border-collapse: collapse; border-bottom: gainsboro 1px solid; border-left: gainsboro 1px solid; border-top: gainsboro 1px solid;border-right: gainsboro 1px solid;'>");
        builder.Append("<tr><td class='subTitle' width='35%'>Property Id: &nbsp; " + lblRefId.Text + "</td>");
        builder.Append("<td align='right' style='padding-right: 10px' width='65%' colspan='2'>");
        builder.Append("</td>");
        builder.Append("</tr>"); 
        builder.Append("<tr><td class='tdForm1'>Location :</td>");
        builder.Append("<td class='tdForm1' colspan='2'>" + tbLocation.Text + "</td>");
        builder.Append("</tr>"); 
        builder.Append("<tr><td class='tdForm1'>Property Type  :</td>");
        builder.Append("<td class='tdForm1' colspan='2'>" + lblPropType.Text + "&nbsp;&nbsp;" + lblFloor.Text  + "</td>");
        builder.Append("</tr>");  
        builder.Append("<tr><td class='tdForm1'>Project/Road Name :</td>");
        builder.Append("<td class='tdForm1' colspan='2'>" + lblProjRdName.Text + "</td>");
        builder.Append("</tr>");
        builder.Append("<tr><td class='tdForm1'>Land Area :</td>");
        builder.Append("<td class='tdForm1' colspan='2'>" + lblLandArea.Text + " sq. ft</td>");
        builder.Append("</tr>");
        builder.Append("<tr><td class='tdForm1'>Built-Up Area :</td>");
        builder.Append("<td class='tdForm1' colspan='2'>" + lblBuiltUpArea.Text + " sq. ft</td>");
        builder.Append("</tr>");
        builder.Append("<tr><td class='tdForm1'>Bedroom :</td>");
        builder.Append("<td class='tdForm1'>" + tbBedroom.Text + "</td>");
        builder.Append("<td width='30%'>Description :</td>");
        builder.Append("</tr>");
        builder.Append("<tr><td class='tdForm1'>Bathroom :</td>");
        builder.Append("<td class='tdForm1'>" + tbBathroom.Text + "</td>");
        builder.Append("<td rowspan='4' valign='top'>" + txtDesc.Text +  "</td>");
        builder.Append("</tr>"); 
                
        builder.Append("</table>");

        return builder.ToString();                           
                                                  
    }
}
