using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Xml;

public partial class WUCSlideShow_3 : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        dbConn objConn = new dbConn();
        DataTable mDt = new DataTable();
        CUtil outil = new CUtil();
        int errCode;
        string errMsg;

        string _sql = "SELECT P.Ref_Cd & P.Ref_Id As PID, P.location, P.AppRefPID, P.AskingPrice, P.RentingPrice, " +
                        "P.Exclusive, L.Loc_Name, " +
                        "I.ImageThumbNailLocation_2, I.ImageFileName, T.PropertyDesc " +
                        "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.location = L.Loc_Code) " +
                        "LEFT JOIN tblPropImage I ON P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id) " +
                        "INNER JOIN tblPropType T ON T.ID = P.PropertyType " +
                        "WHERE P.Exclusive = 1 AND P.PActive = 1 AND P.PStatus = 1" +
                        "AND ((I.ImageActive = 1 AND I.ImageProfilePic = 1) OR I.ImageActive IS NULL)";

           mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

           string askingPrice;
           string rental;

           if (errCode == 0)
           {
               StringBuilder builder = new StringBuilder();
               builder.Append("<ul>");
               //width: 160px;
               //height: 218px; 
               foreach (DataRow row in mDt.Rows)
               {
                   builder.Append("<li>");
                   builder.Append("<div class='contain_image3' align='center'>");
                   builder.Append("<span></span>");
                   builder.Append("<a style='text-decoration:none;' href='ViewPropertyProfile.aspx?PID=" + row["PID"].ToString() + "' >");
                   //builder.Append("<img border='0' class='captify' alt='Property Code : " + row["AppRefPID"].ToString() + "' src='" + imagePath(row["ImageThumbNailLocation_2"].ToString()) + "' />");
                   // class='captify'
                   builder.Append("<img border='0'   src='" + imagePath(row["ImageThumbNailLocation_2"].ToString()) + "' width='160px' height='160px' />");
                   builder.Append("</a>");
                   builder.Append("<p style='font-weight:bold;font-size:10px;'>");
                  // builder.Append("Property Code : " + row["AppRefPID"].ToString());
                  // builder.Append("<br/>");
                   builder.Append("Located at : " + row["Loc_Name"].ToString());
                   builder.Append("<br/>");
                   builder.Append(row["PropertyDesc"].ToString());
                   builder.Append("<br/>");
                   askingPrice = row["AskingPrice"].ToString();
                   builder.Append("Asking Price : Rm " + outil.factorPrice(askingPrice));

                   rental = row["RentingPrice"].ToString();

                   if (Convert.ToDecimal(rental) < 1)
                   {
                       rental = " - ";
                   }
                   else
                   {
                       rental = outil.factorPrice(rental);
                   }

                   builder.Append("<br/>");
                   builder.Append("Rental : Rm " + rental);
                   builder.Append("</p>");
                   builder.Append("</div>");
                   builder.Append("</li>");
               }
               builder.Append("</ul>");
               ltImageGallery.Text = builder.ToString();
           }
           else
           {
               Response.Write(errMsg);
           }

           XmlDocument doc = new XmlDocument();
           doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));

           XmlNode root = doc.DocumentElement;
           txtSpeed.Value = root.SelectSingleNode("SlideShowSpeed").ChildNodes[0].Value;
           txtAuto.Value = root.SelectSingleNode("SlideShowDelay").ChildNodes[0].Value;
           
    }

    private string imagePath(string originalPath)
    {
        return (originalPath == "") ? "Images/Item/nolistings.gif" : originalPath;
       
    }
}
