using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;


public partial class Default2 : System.Web.UI.Page
{

    #region
    private int StrataCount = 0;
    private int LandedCount = 0;
    private int CommercialCount = 0;
    private int FactoriesCount = 0;
    #endregion

    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        if (!Page.IsPostBack)
        {
            loadProperty();
            //generateDatatable();
        }

        if (Session["user_id"] != null)
        {
            ImgBtnSettings.Visible = true;
            ImageBtnLogout.Visible = true;
        }
        else
        {
            ImageBtnLogout.Visible = false;
            ImgBtnSettings.Visible = false;
        }
    

    }

    public void loadProperty()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        DataTable mDt = new DataTable();


        #region Strate
        string _sql = "SELECT TOP 4 * FROM ( " +
                      "SELECT P.Ref_Cd & P.Ref_Id AS PID, P.Location, P.PropertyCode, " + 
                      "P.PropertyType, P.BuiltUp_Area, P.Land_Area, P.PropertyCondition, P.Tenure, " +
                      "P.PStatus, P.InsDate, " +
                      "P.AskingPrice, P.RentingPrice, P.Exclusive, L.Loc_Name, T.PropertyDesc, " +
                      "I.ImageFileLocation, I.ImageThumbNailLocation_1 " +
                      "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.Location = L.Loc_Code) " +
                      "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " + 
                      "LEFT JOIN tblPropImage I ON P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id " +
                      "WHERE " +
                      "LEFT(P.Ref_Cd, 1) = 'S'" +
                      "AND P.Exclusive = 0 " +
                      "AND (I.ImageAutoID = " +
                      "(SELECT MAX(I2.ImageAutoID) FROM tblPropImage I2 WHERE I2.Ref_Cd & I2.Ref_Id = P.Ref_Cd & P.Ref_Id AND I2.ImageProfilePic = 1) " +
                      "OR I.ImageAutoID is null ) " +
                      "AND P.PActive = 1 " +
                      "AND ((P.PStatus = 2 AND DateDiff('d', PStatusDate, Date()) < 7) OR P.PStatus = 1)" +
                      "ORDER BY P.InsDate DESC)";

       

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            Response.Write(errMsg);
        }

        StrataCount = mDt.Rows.Count;
        DLImgGallery.DataSource = mDt;
        DLImgGallery.DataBind();
        mDt.Clear();

        if (StrataCount > 0)
        {
           StringBuilder strScript = new StringBuilder();
          // strScript.Append(@"<script type='text/javascript'>");
           //strScript.Append(@"alert(1);</script>");

           //string jScript;
           //jScript = "<script>function JavScriptFn(){alert" +
           //  " ('Client Function in javascript is call')}</script";
           //jScript = jScript + ">";
           // //script>";
     
        

          // Page.ClientScript.RegisterClientScriptBlock(this.GetType(), "errScript", strScript.ToString(), true);
        }

        #endregion

        _sql = "SELECT TOP 4 * FROM ( " +    
                      "SELECT  P.Ref_Cd & P.Ref_Id AS PID, P.Location, P.PropertyCode, " +
                      "P.PropertyType, P.BuiltUp_Area, P.Land_Area, P.PropertyCondition, P.Tenure, " +
                      "P.PStatus, P.InsDate, " +
                      "P.AskingPrice, P.RentingPrice, P.Exclusive, L.Loc_Name, T.PropertyDesc, " +
                      "I.ImageFileLocation, I.ImageThumbNailLocation_1 " +
                      "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.Location = L.Loc_Code) " +
                      "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
                      "LEFT JOIN tblPropImage I ON P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id " +
                      "WHERE " +
                      "LEFT(P.Ref_Cd, 1) = 'L'" +
                      "AND P.Exclusive = 0 " +
                      "AND (I.ImageAutoID = " +
                      "(SELECT MAX(I2.ImageAutoID) FROM tblPropImage I2 WHERE I2.Ref_Cd & I2.Ref_Id = P.Ref_Cd & P.Ref_Id AND I2.ImageProfilePic = 1) " +
                      "OR I.ImageAutoID is null ) " +
                      "AND P.PActive = 1 " +
                      "AND ((P.PStatus = 2 AND DateDiff('d', PStatusDate, Date()) < 7) OR P.PStatus = 1)" +
                      "ORDER BY P.InsDate DESC)";

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);
        LandedCount = mDt.Rows.Count;
        DLLanded.DataSource = mDt;
        DLLanded.DataBind();
        mDt.Clear();

        _sql = "SELECT TOP 4 P.Ref_Cd & P.Ref_Id AS PID, P.Location, P.PropertyCode, " +
                 "P.PropertyType, P.BuiltUp_Area, P.Land_Area, P.PropertyCondition, P.Tenure, " +
                 "P.PStatus, P.InsDate, " +
                 "P.AskingPrice, P.RentingPrice, P.Exclusive, L.Loc_Name, T.PropertyDesc, " +
                 "I.ImageFileLocation, ImageThumbNailLocation_1 " +
                 "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.Location = L.Loc_Code) " +
                 "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
                 "LEFT JOIN tblPropImage I ON P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id " +
                 "WHERE " +
                 "LEFT(P.Ref_Cd, 1) = 'C'" +
                 "AND P.Exclusive = 0 " +
                 "AND (I.ImageAutoID = " +
                 "(SELECT MAX(I2.ImageAutoID) FROM tblPropImage I2 WHERE I2.Ref_Cd & I2.Ref_Id = P.Ref_Cd & P.Ref_Id AND I2.ImageProfilePic = 1) " +
                 "OR I.ImageAutoID is null ) " +
                 "AND P.PActive = 1 " +
                 "AND ((P.PStatus = 2 AND DateDiff('d', PStatusDate, Date()) < 7) OR P.PStatus = 1)" +
                 "ORDER BY P.InsDate DESC";

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);
        CommercialCount = mDt.Rows.Count;

        if (CommercialCount > 0)
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(),
            "alert", "blinkId('FooterCommercial',1);", true);
        }

  
        DLCommercial.DataSource = mDt;
        DLCommercial.DataBind();
        mDt.Clear();

        #region ----- Factories -----

        _sql = "SELECT TOP 4 P.Ref_Cd & P.Ref_Id AS PID, P.Location, P.PropertyCode, " +
              "P.PropertyType, P.BuiltUp_Area, P.Land_Area, P.PropertyCondition, P.Tenure, " +
              "P.PStatus, P.InsDate, " +
              "P.AskingPrice, P.RentingPrice, P.Exclusive, L.Loc_Name, T.PropertyDesc, " +
              "I.ImageFileLocation, I.ImageThumbNailLocation_1 " +
              "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.Location = L.Loc_Code) " +
              "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
              "LEFT JOIN tblPropImage I ON P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id " +
              "WHERE " +
              "LEFT(P.Ref_Cd, 1) = 'F'" +
              "AND P.Exclusive = 0 " +
              "AND (I.ImageAutoID = " +
              "(SELECT MAX(I2.ImageAutoID) FROM tblPropImage I2 WHERE I2.Ref_Cd & I2.Ref_Id = P.Ref_Cd & P.Ref_Id AND I2.ImageProfilePic = 1) " +
              "OR I.ImageAutoID is null ) " +
              "AND P.PActive = 1 " +
              "AND ((P.PStatus = 2 AND DateDiff('d', PStatusDate, Date()) < 7) OR P.PStatus = 1)" +
              "ORDER BY P.InsDate DESC";

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);
        FactoriesCount = mDt.Rows.Count;

        if (FactoriesCount > 0)
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(),
            "alert", "blinkId('FooterFactories',1);", true);
        }

        DLFactories.DataSource = mDt;
        DLFactories.DataBind();
        mDt.Clear();

        #endregion
    }


    protected void DLImgGallery_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        #region ----- Item -----
        if (e.Item.ItemType == ListItemType.Item ||
        e.Item.ItemType == ListItemType.AlternatingItem)
        {
            DataRowView drv = (DataRowView)(e.Item.DataItem);
            string askingPrice = drv["AskingPrice"].ToString();

            CUtil outil = new CUtil();

            Label lbl = (Label)e.Item.FindControl("lblAskingPrice");
            lbl.Text = outil.factorPrice(askingPrice);

            if (drv["PStatus"].ToString() == "2")
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<div class='soldThumbNail'>");
                sb.Append("<img src='Images/Item/main_icon_sold.gif' alt='sold' />");
                sb.Append("</div>");

                Literal lit;
                lit = (Literal)e.Item.FindControl("ltSoldIcon");
                lit.Text = sb.ToString();
            }
            else
            {
                // Sold would fall in here
                DateTime Tday = DateTime.Now;
                DateTime Iday = Convert.ToDateTime(drv["InsDate"]);
                TimeSpan span = Tday.Subtract(Iday);

                if (span.Days <= 7)
                {
                    StringBuilder sb = new StringBuilder();
                    sb.Append("<div class='newThumbNail'>");
                    sb.Append("<img src='Images/Item/new_icon.gif' alt='new' style='float:right;'/>");
                    sb.Append("</div>");

                    Literal lit;
                    lit = (Literal)e.Item.FindControl("ltSoldIcon");
                    lit.Text = sb.ToString();
                }
            }

            if (drv["ImageThumbNailLocation_1"].ToString() == "")
            {
                Image imgBtn = (Image)e.Item.FindControl("ImgHighProperty");
                imgBtn.ImageUrl = "Images/Item/nolistings.gif";
                
            }

            if (Convert.ToDecimal(drv["AskingPrice"].ToString()) < 1)
            {
                Label lblAsking = (Label)e.Item.FindControl("lblAskingPrice");
                lblAsking.Text = "-";
            }

            if (Convert.ToDecimal(drv["RentingPrice"].ToString()) < 1)
            {
                Label lblRental = (Label)e.Item.FindControl("lblRentingPrice");
                lblRental.Text = "-";
            }

            if (Convert.ToDecimal(drv["Land_Area"].ToString()) < 1)
            {
                Label lblLandArea = (Label)e.Item.FindControl("lblLandArea");
                lblLandArea.Text = "-";
            }
        }
        #endregion

        #region ----- Footer -----

        if (e.Item.ItemType == ListItemType.Footer)
        {
            Label lbl = (Label)e.Item.FindControl("lblFooter");

            if (StrataCount > 0)
            {
                lbl.Text = "Click Here For More . . .";
            }
            else
            {
                lbl.Text = "No Data";
            }
        }

        #endregion
     
    }
    protected void DLLanded_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item ||
        e.Item.ItemType == ListItemType.AlternatingItem)
        {
            DataRowView drv = (DataRowView)(e.Item.DataItem);
            string askingPrice = drv["AskingPrice"].ToString();

            CUtil outil = new CUtil();

            Label lbl = (Label)e.Item.FindControl("lblAskingPrice");
            lbl.Text = outil.factorPrice(askingPrice);

            if (drv["PStatus"].ToString() == "2")
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<div class='soldThumbNail'>");
                sb.Append("<img src='Images/Item/main_icon_sold.gif' alt='sold' />");
                sb.Append("</div>");

                Literal lit;
                lit = (Literal)e.Item.FindControl("ltSoldIcon");
                lit.Text = sb.ToString();
            }

            if (drv["ImageThumbNailLocation_1"].ToString() == "")
            {
                Image imgBtn = (Image)e.Item.FindControl("ImgHighProperty");
                imgBtn.ImageUrl = "Images/Item/nolistings.gif";
            }

            if (Convert.ToDecimal(drv["AskingPrice"].ToString()) < 1)
            {
                Label lblAsking = (Label)e.Item.FindControl("lblAskingPrice");
                lblAsking.Text = "-";
            }

            if (Convert.ToDecimal(drv["RentingPrice"].ToString()) < 1)
            {
                Label lblRental = (Label)e.Item.FindControl("lblRentingPrice");
                lblRental.Text = "-";
            }

            if (Convert.ToDecimal(drv["Land_Area"].ToString()) < 1)
            {
                Label lblLandArea = (Label)e.Item.FindControl("lblLandArea");
                lblLandArea.Text = "-";
            }
        }

        if (e.Item.ItemType == ListItemType.Footer)
        {
            Label lbl = (Label)e.Item.FindControl("lblFooter");

            if (LandedCount > 0)
            {
                lbl.Text = "Click Here For More . . .";
            }
            else
            {
                lbl.Text = "No Data";
            }
        }
    }
    protected void DLCommercial_ItemDataBound(object sender, DataListItemEventArgs e)
    {

        #region ----- Item -----
        if (e.Item.ItemType == ListItemType.Item ||
        e.Item.ItemType == ListItemType.AlternatingItem)
        {
            DataRowView drv = (DataRowView)(e.Item.DataItem);
            string askingPrice = drv["AskingPrice"].ToString();

            CUtil outil = new CUtil();

            Label lbl = (Label)e.Item.FindControl("lblAskingPrice");
            lbl.Text = outil.factorPrice(askingPrice);

            if (drv["PStatus"].ToString() == "2")
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<div class='soldThumbNail'>");
                sb.Append("<img src='Images/Item/main_icon_sold.gif' alt='sold' />");
                sb.Append("</div>");

                Literal lit;
                lit = (Literal)e.Item.FindControl("ltSoldIcon");
                lit.Text = sb.ToString();
            }

            if (Convert.ToDecimal(drv["AskingPrice"].ToString()) < 1)
            {
                Label lblAsking = (Label)e.Item.FindControl("lblAskingPrice");
                lblAsking.Text = "-";
            }

            if (Convert.ToDecimal(drv["RentingPrice"].ToString()) < 1)
            {
                Label lblRental = (Label)e.Item.FindControl("lblRentingPrice");
                lblRental.Text = "-";
            }

            if (Convert.ToDecimal(drv["Land_Area"].ToString()) < 1)
            {
                Label lblLandArea = (Label)e.Item.FindControl("lblLandArea");
                lblLandArea.Text = "-";
            }
        }
        #endregion

        #region ----- Footer ------

        if (e.Item.ItemType == ListItemType.Footer)
        {
            Label lbl = (Label)e.Item.FindControl("lblFooter");

            if (CommercialCount > 0)
            {
                lbl.Text = "Click Here For More . . .";
            }
            else
            {
                lbl.Text = "No Data";
            }
        }

        #endregion
    }

    protected void DLFactories_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        #region ----- Factories -----

        if (e.Item.ItemType == ListItemType.Item ||
        e.Item.ItemType == ListItemType.AlternatingItem)
        {
            DataRowView drv = (DataRowView)(e.Item.DataItem);
            string askingPrice = drv["AskingPrice"].ToString();

            CUtil outil = new CUtil();

            Label lbl = (Label)e.Item.FindControl("lblAskingPrice");
            lbl.Text = outil.factorPrice(askingPrice);

            if (drv["PStatus"].ToString() == "2")
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<div class='soldThumbNail'>");
                sb.Append("<img src='Images/Item/main_icon_sold.gif' alt='sold' />");
                sb.Append("</div>");

                Literal lit;
                lit = (Literal)e.Item.FindControl("ltSoldIcon");
                lit.Text = sb.ToString();
            }

            if (Convert.ToDecimal(drv["AskingPrice"].ToString()) < 1)
            {
                Label lblAsking = (Label)e.Item.FindControl("lblAskingPrice");
                lblAsking.Text = "-";
            }

            if (Convert.ToDecimal(drv["RentingPrice"].ToString()) < 1)
            {
                Label lblRental = (Label)e.Item.FindControl("lblRentingPrice");
                lblRental.Text = "-";
            }

            if (Convert.ToDecimal(drv["Land_Area"].ToString()) < 1)
            {
                Label lblLandArea = (Label)e.Item.FindControl("lblLandArea");
                lblLandArea.Text = "-";
            }
        }

        #endregion

        #region ----- Footer -----

        if (e.Item.ItemType == ListItemType.Footer)
        {
            Label lbl = (Label)e.Item.FindControl("lblFooter");

            if (FactoriesCount > 0)
            {
                lbl.Text = "Click Here For More . . .";
            }
            else
            {
                lbl.Text = "No Data";
            }
        }

        #endregion
    }

    public void Page_Error(object sender, EventArgs e)
    {
        Exception objErr = Server.GetLastError().GetBaseException();
        string err = "<b>Error Caught in Page_Error event</b><hr><br>" +
                     "<br><b>Error in: </b>" + Request.Url.ToString() +
                     "<br><b>Error Message: </b>" + objErr.Message.ToString() +
                     "<br><b>Stack Trace:</b><br>" +
                          objErr.StackTrace.ToString();
        Response.Write(err.ToString());
        Server.ClearError();
    }
    protected void ImgBtnSettings_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect("LoginLandingPage.aspx");
    }
    protected void ImageBtnLogout_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect("LoginPage.aspx?Mode=2");
    }
}
