using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Xml;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Text;

public partial class managePropertyListing : System.Web.UI.Page
{
    public const int EDIT_MODE = 1;
    public const int NEW_MODE = 2;

    [System.Web.Services.WebMethod]
    public static string ShowAvailability(string refId)
    {
        string errMsg;
        bool returnResult;
        int errCode;
        dbConn objConn = new dbConn();
        string _sql = "SELECT AppRefPID FROM tblPropListing " +
                      "WHERE AppRefPID = '" + refId + "'";

        returnResult = objConn.IfExist(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            return "Error";
        }
        else
        {
            return (returnResult) ? "True" : "False";
        }

    }


    protected void Page_Load(object sender, EventArgs e)
    {
        HtmlLink link = new HtmlLink();
        HtmlLink link2 = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

        link2.Href = "CSS/ajaxtoolkit.css";
        link2.Attributes.Add("rel", "stylesheet");
        link2.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link2);

        if (!Page.IsPostBack)
        {
            pageInit();
            loadXmlData();
        }

    }

    #region ----- Event Save, Update, Rent, Sales, Upload, DLImgGallery_ItemCommand -----

    protected void btnSave_Click(object sender, EventArgs e)
    {
        Master.checkSessionExpired();

        string errMsg;
        int errCode;
        string _sql;
        string _getIdsql;
        string _ex;
        string _askingPrice;
        string _rentPrice;
        string _NoOfBedRoom = "0";
        string _NoOfBathRoom = "0";
        string _PropertySpec = string.Empty;
        dbConn objConn = new dbConn();

        string location = WUCFT.selectedValue;
        _sql = "SELECT Loc_Group FROM tblPropLocation WHERE Loc_Code = '" + location + "'";

        string refcd = ddlPropertyCat.SelectedValue + objConn.ExecScalar(_sql, out errCode, out errMsg).ToString();


        _getIdsql = "SELECT IIf(IsNull(Max(Ref_Id)),0,Max(Ref_Id)) FROM tblPropListing WHERE Ref_Cd = '" + refcd + "'";
        int refid = objConn.getMax(_getIdsql, out errCode, out errMsg) + 1;

        _ex = (cbExclusive.Checked) ? "1" : "0";

        if (cbThous.Checked)
        {
            _askingPrice = Convert.ToString(float.Parse(txtAskingPrice.Text) * 1000);
        }
        else if (cbMil.Checked)
        {
            _askingPrice = Convert.ToString(float.Parse(txtAskingPrice.Text) * 1000000);
        }
        else
        {
            _askingPrice = txtAskingPrice.Text;
        }

        if (cbThousRenting.Checked)
            _rentPrice = Convert.ToString(float.Parse(txtRentingPrice.Text) * 1000);
        else
            _rentPrice = txtRentingPrice.Text;


        string appstatus = string.Empty;

        if (!string.IsNullOrEmpty(Session["user_accesslevel"].ToString()))
        {
            if (Session["user_accesslevel"].ToString() == "1")
            {
                appstatus = "1";
            }
            else
            {
                appstatus = Convert.ToInt16(CUtil.listingStatus.Pending_Approval).ToString();
            }
        }
        else
        {
            // Todo : Session timeout
            Response.Redirect("main.aspx");
        }

        if (refcd.StartsWith("S"))
        {
            _NoOfBedRoom = txtBoxAppNoBedroom.Text;
            _NoOfBathRoom = txtBoxAppNoBathroom.Text;
            _PropertySpec = txtFloor.Text;
        }
        else if (refcd.StartsWith("L"))
        {
            _NoOfBedRoom = txtBoxLandedNoBedroom.Text;
            _NoOfBathRoom = txtBoxLandedNoBathroom.Text;
            _PropertySpec = ddlLandedStorey.SelectedValue;
        }

        string leaseYear = string.IsNullOrEmpty(txtLeaseHoldYear.Text) ? "0" : txtLeaseHoldYear.Text;
        string ExpiredDate = string.IsNullOrEmpty(txtExpiredYear.Text) ? "0" : txtLeaseHoldYear.Text;



        _sql = "INSERT INTO tblPropListing(Ref_Cd, Ref_Id, AppRefPID, location, PropertyCode, PropertyType, BuiltUp_Area, Land_Area, PropertySpec, " +
               "PropertyCondition, FurnishedCondition, Tenure, TYear, ExpiredDate, NoOfBedRoom, NoOfBathRoom, CarPark, AskingPrice, RentingPrice, Exclusive, PDesc, InsBy, PActive) VALUES " +
               "('" + refcd + "'" + "," + "'" + refid.ToString() + "'" + "," + "'" + txtEAppPropRefID.Text + "'" + "," +
               "'" + location + "'" + "," +
               "'" + txtrdProjName.Text.ToUpper() + "'" + "," +
               "'" + ddlPropType.SelectedValue + "'" + "," + "'" + txtBuiltUpArea.Text + "'" + "," +
               "'" + txtLandArea.Text + "'" + "," +
               "'" + _PropertySpec + "'" + "," +
               "'" + rdBtnListPropCond.SelectedValue + "'" + "," +
               "'" + rdBtnListFurCond.SelectedValue + "'" + "," +
               "'" + rdBtnListTenure.SelectedValue + "'" + "," +
               "'" + leaseYear + "'" + "," +
               "'" + ExpiredDate + "'" + "," +
               _NoOfBedRoom + "," + _NoOfBathRoom + "," +
               txtNumberOfCarPark.Text + "," +
               "'" + _askingPrice + "'" + "," +
               "'" + _rentPrice + "'" + "," + "'" + _ex + "'" + "," +
               "'" + txtDesc.Text.Replace("'", "''") + "'" + "," +
            // String.Format("{0:yyyy/MM/dd}", DateTime.Today) + "," +
               Session["user_id"].ToString() + "," + appstatus + ")";



        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg + "(" + refcd + refid.ToString() + ")";
        }
        else
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Blue;
            lblSysErrMsg.Text = "New Listing has been added successfully";
            pageMode(EDIT_MODE, refcd + refid.ToString());
        }

        #region Email Notifcation

        if (appstatus != "1")
        {
            SendEmailNotification(refcd + refid.ToString());
        }

        #endregion
    }

    private void SendEmailNotification(string refId)
    {
        try
        {

            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));

            XmlNode root = doc.DocumentElement;


            XmlNodeList objEmailNotification = root.SelectNodes("EmailNotification");

            if (objEmailNotification.Item(0)["ListingApproval"].InnerText == "1")
            {
                string pageURL = "http://" + Request.ServerVariables["SERVER_NAME"] + Request.ServerVariables["URL"] + "?" + Request.QueryString;

                System.Web.Mail.MailMessage myMail = new System.Web.Mail.MailMessage();

		// Date : 2 Jan 2011, Replace mail.eliteproperties.com.my to localhost
                  
                myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/sendusing", 2);
                myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/smtpserver", "localhost");
                myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/smtpserverport", 25);
                myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate", "1");
                myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/sendusername", "guest@eliteproperties.com.my");
                myMail.Fields.Add("http://schemas.microsoft.com/cdo/configuration/sendpassword", "q1w2e3");

                myMail.From = "guest@eliteproperties.com.my";
                myMail.To = objEmailNotification.Item(0)["Receiving"].InnerText;

                StringBuilder sb = new StringBuilder();
                sb.Append("New Listing has been submitted");
                sb.Append("<p>Listing Id : " + refId + "</p>");


                myMail.Subject = "New Listing waiting for your approval";
                myMail.BodyFormat = System.Web.Mail.MailFormat.Html;
                myMail.Body = sb.ToString();


                System.Web.Mail.SmtpMail.SmtpServer = "mail.eliteproperties.com.my";
                System.Web.Mail.SmtpMail.Send(myMail);
            }
        }
        catch (Exception ex)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = ex.ToString();
        }
    }

    protected void btnUpdate_Click(object sender, EventArgs e)
    {
        Master.checkSessionExpired();

        dbConn objConn = new dbConn();
        string _sql;
        int errCode;
        string errMsg;
        int _ex;
        string _NoOfBedRoom = "0";
        string _NoOfBathRoom = "0";
        string _PropertySpec = string.Empty;
        string _askingPrice = string.Empty;
        string _rentPrice = string.Empty;
        string _carPark = string.Empty;

        if (cbExclusive.Checked)
        {
            _ex = 1;
        }
        else
        {
            _ex = 0;
        }

        if (lblPropertyID.Text.StartsWith("S"))
        {
            _NoOfBedRoom = txtBoxAppNoBedroom.Text;
            _NoOfBathRoom = txtBoxAppNoBathroom.Text;
            _PropertySpec = txtFloor.Text;
        }
        else if (lblPropertyID.Text.StartsWith("L"))
        {
            _NoOfBedRoom = txtBoxLandedNoBedroom.Text;
            _NoOfBathRoom = txtBoxLandedNoBathroom.Text;
            _PropertySpec = ddlLandedStorey.SelectedValue;
        }

        if (cbThous.Checked)
        {
            _askingPrice = Convert.ToString(float.Parse(txtAskingPrice.Text) * 1000);
        }
        else if (cbMil.Checked)
        {
            _askingPrice = Convert.ToString(float.Parse(txtAskingPrice.Text) * 1000000);
        }
        else
        {
            _askingPrice = txtAskingPrice.Text;
        }

        if (cbThousRenting.Checked)
            _rentPrice = Convert.ToString(float.Parse(txtRentingPrice.Text) * 1000);
        else
            _rentPrice = txtRentingPrice.Text;


        string location = WUCFT.selectedValue;

        _carPark = (txtNumberOfCarPark.Text == string.Empty) ? "0" : txtNumberOfCarPark.Text;

        _sql = "UPDATE tblPropListing SET " +
               "AppRefPID = '" + txtEAppPropRefID.Text + "', " +
               "location = '" + location + "', " +
               "AskingPrice = '" + _askingPrice + "', " +
               "RentingPrice = '" + _rentPrice + "'," +
               "NoOfBedRoom = '" + _NoOfBedRoom + "'," +
               "NoOfBathRoom = '" + _NoOfBathRoom + "', " +
               "CarPark = " + _carPark + ", " +
               "PropertySpec = '" + _PropertySpec + "', " +
               "Tenure = '" + rdBtnListTenure.SelectedValue + "', " +
               "BuiltUp_Area = '" + txtBuiltUpArea.Text + "', " +
               "Exclusive = '" + _ex.ToString() + "', " +
               "PropertyCode = '" + txtrdProjName.Text.ToUpper() + "', " +
               "PDesc = '" + txtDesc.Text.Trim() + "', " +
               "Land_Area = '" + txtLandArea.Text + "' " +
               "WHERE Ref_Cd & Ref_Id = '" + lblPropertyID.Text + "'";

        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Blue;
            lblSysErrMsg.Text = "Listing has been update successfully";
            pageMode(EDIT_MODE, lblPropertyID.Text);
        }

    }

    protected void btnRented_Click(object sender, EventArgs e)
    {
        LisitngOp(Convert.ToInt16(CUtil.listingState.Rented).ToString());
    }

    protected void btnSold_Click(object sender, EventArgs e)
    {
        LisitngOp(Convert.ToInt16(CUtil.listingState.Sold).ToString());
    }

    // 4/05/2011 -- Will Create 3 set of photo, even not an exclusive
    // 13/06/2011 -- If the this is the first photo, auto set as primary
    protected void btnUpload_Click(object sender, EventArgs e)
    {
        string sql;

        const string ORIGIN_PATHNAME = "Gallery/Property/";
        const string NORMAL_THUMBNAIL_PATHNAME = "Gallery/Thumbnail/";
        const string EXCLUSIVE_THUMBNAIL_PATHNAME = "Gallery/ThumbnailEX/";

        dbConn objConn = new dbConn();
        string propId = lblPropertyID.Text;
        string refcd = propId.Substring(0, 2);
        string refid = propId.Substring(2, propId.Length - 2);
        string errMsg;
        int errCode;
        int rndFileName;
        int profilePic = 0;

        if (!String.IsNullOrEmpty(lblPropertyID.Text.Trim()))
        {
            if (UploadFile.HasFile)
            {
                HttpPostedFile upfile = UploadFile.PostedFile;
                int fileLength = upfile.ContentLength;
                int fileSize = fileLength / 1024;

                // -- Initialize system settings
                XmlDocument doc = new XmlDocument();
                doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));
                XmlNode root = doc.DocumentElement;
                string ImgFileSize = root.SelectSingleNode("ImgFileSize").ChildNodes[0].Value;

                if (fileSize > Convert.ToInt16(ImgFileSize))
                {
                    lblMsg.Text = "Image File size exceed limit. Should be less than " + ImgFileSize;
                }
                else
                {
                    #region Image Process
                    try
                    {
                        Random rnd = new Random();
                        rndFileName = rnd.Next(1000, 9999);
                        //UploadFile.PostedFile.ContentLength
                        byte[] fileBytes = new byte[UploadFile.PostedFile.ContentLength];
                        // fill in byte array 
                        using (System.IO.Stream stream = UploadFile.PostedFile.InputStream)
                        {
                            stream.Read(fileBytes, 0, UploadFile.PostedFile.ContentLength);
                        }

                        string uploadFileName = DateTime.Now.Second.ToString() + DateTime.Now.Millisecond.ToString() + rndFileName + "." + CUtil.GetExtension(UploadFile.FileName);
                        string ImgPath = ORIGIN_PATHNAME + uploadFileName;
                        string ThumbPath = NORMAL_THUMBNAIL_PATHNAME + uploadFileName;
                        string ThumbPath2 = EXCLUSIVE_THUMBNAIL_PATHNAME + uploadFileName;

                        CUtil.ImgSize _Img = new CUtil.ImgSize();

                        _Img._Height = 400;
                        _Img._Width = 400;

                        #region get System Settings Data

                        XmlNodeList objListImg = root.SelectNodes("ImageSize");
                        string ThumbNailSize = objListImg.Item(0)["ThumbNailSize"].InnerText;
                        string ThumbNailExSize = objListImg.Item(0)["ThumbNailSizeEx"].InnerText;
                        string Watermark = root.SelectSingleNode("Watermark").ChildNodes[0].Value;

                        #endregion


                       // Response.Write(Server.MapPath(ORIGIN_PATHNAME + uploadFileName));

                        System.IO.File.WriteAllBytes(Server.MapPath(ORIGIN_PATHNAME + uploadFileName), ReSizeImageFile(fileBytes, _Img, Watermark));
                        System.Drawing.Image img1 = System.Drawing.Image.FromFile(MapPath(ORIGIN_PATHNAME) + uploadFileName);

                        decimal h = img1.Height;
                        decimal w = img1.Width;
                        CUtil.ImgSize _ThumbImg = new CUtil.ImgSize();
                        CUtil.ImgSize _ThumbExImg = new CUtil.ImgSize();
                        _ThumbImg = CUtil.thumbnailCal(h, w, int.Parse(ThumbNailSize));
                        _ThumbExImg = CUtil.thumbnailCal(h, w, int.Parse(ThumbNailExSize));

                        System.Drawing.Image bmp1 = img1.GetThumbnailImage(_ThumbImg._Width, _ThumbImg._Height, null, IntPtr.Zero);

                        System.Drawing.Image bmp2 = img1.GetThumbnailImage(_ThumbExImg._Width, _ThumbExImg._Height, null, IntPtr.Zero);

                        bmp1.Save(MapPath(NORMAL_THUMBNAIL_PATHNAME + uploadFileName));

                        //if (cbExclusive.Checked)
                        //{
                        //    bmp2.Save(MapPath(EXCLUSIVE_THUMBNAIL_PATHNAME + uploadFileName));
                        //    bmp2.Dispose();
                        //}
                        //else
                        //{
                        //    ThumbPath2 = "";
                        //}

                        bmp2.Save(MapPath(EXCLUSIVE_THUMBNAIL_PATHNAME + uploadFileName));
                        bmp2.Dispose();

                        img1.Dispose();
                        bmp1.Dispose();

                        if (cbProfilePicture.Checked)
                        {
                            profilePic = 1;
                        }
                        else
                        {
                            if (int.Parse(lblTotalPhoto.Text) == 0)
                            {
                                profilePic = 1;
                            }
                        }


                        sql = "INSERT INTO tblPropImage(Ref_Cd, Ref_Id, ImageFileName, ImageFileDesc, ImageFileLocation, " +
                              "ImageThumbNailLocation_1, ImageThumbNailLocation_2, ImageProfilePic, ImageActive) VALUES ('" + refcd + "'" + "," + "'" + refid + "'" + "," +
                              "'" + txtbImageName.Text + "'" + "," + "'" + txtbImageDesc.Text + "'" + "," + "'" + ImgPath + "'" + "," +
                              "'" + ThumbPath + "'" + "," + "'" + ThumbPath2 + "'" + "," + "'" + profilePic + "'" + "," + '1' + ")";

                        objConn.ExecSQL(sql, out errCode, out errMsg);

                        if (errCode == -1)
                        {
                            lblMsg.ForeColor = System.Drawing.Color.Red;
                            lblMsg.Text = errMsg;
                        }
                        else
                        {
                            lblMsg.ForeColor = System.Drawing.Color.Blue;
                            //lblMsg.Text = "Photo upload successfully";
                        }

                        txtbImageName.Text = "";
                        txtbImageDesc.Text = "";
                        cbProfilePicture.Checked = false;

                        loadPropertyImg();

                        clearUploadInfo();

                    }
                    catch (Exception ex)
                    {
                        lblMsg.Text = ex.Message.ToString();
                    }
                    #endregion

                }


            }
        }
    }

    protected void DLImgGallery_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.CommandName == "ImageEdit")
        {
            // This session is to help normal user to access to ManagePropertyProfile Page
            Session["SelfEdit"] = "1";
            Response.Redirect("ManagePropertyProfile.aspx?PID=" + lblPropertyID.Text);
        }

      
    }


    #endregion

    #region ----- User Defined Function -----

    private void clearUploadInfo()
    {
        txtbImageName.Text = string.Empty;
        txtbImageDesc.Text = string.Empty;
    }

    public byte[] ReSizeImageFile(byte[] imageFile, CUtil.ImgSize _targetSize, string _watermark)
    {

        Font font = new Font("Book Antiqua", 22, FontStyle.Bold, GraphicsUnit.Pixel);
        //Color color = Color.FromArgb(254, 254, 0, 80);
        Color color = Color.FromArgb(254, 128, 0, 128);
        //Adds a black watermark with a low alpha value (almost transparent).
        //The pixel point to draw the watermark at (this example puts it at 100, 100 (x, y)).
        SolidBrush brush = new SolidBrush(color);

        MemoryStream ms = new MemoryStream(imageFile);

        using (System.Drawing.Image oldImage =
                    System.Drawing.Image.FromStream(ms))
        {
            Size newSize = CUtil.CalculateDimensions(oldImage.Size, _targetSize);

            using (Bitmap newImage =
                new Bitmap(newSize.Width, newSize.Height, PixelFormat.Format24bppRgb))
            {
                using (Graphics canvas = Graphics.FromImage(newImage))
                {
                    canvas.SmoothingMode = SmoothingMode.AntiAlias;
                    canvas.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    canvas.PixelOffsetMode = PixelOffsetMode.HighQuality;

                    canvas.DrawImage(oldImage,
                        new Rectangle(new Point(0, 0), newSize));


                    int _X = newSize.Width / 2;
                    int _Y = newSize.Height / 2;

                    Point atPoint = new Point(_X, _Y);
                    StringFormat sf = new StringFormat();
                    sf.Alignment = StringAlignment.Center;
                    sf.LineAlignment = StringAlignment.Center;

                    canvas.DrawString(_watermark, font, brush, atPoint, sf);

                    MemoryStream m = new MemoryStream();
                    newImage.Save(m, ImageFormat.Jpeg);
                    return m.GetBuffer();

                }

            }
        }
    }

    private void LisitngOp(string tranCode)
    {
        dbConn objConn = new dbConn();
        string _sql;
        int errCode;
        string errMsg;

        _sql = "UPDATE tblPropListing SET PStatus = '" + tranCode + "'" +
               " WHERE Ref_Cd & Ref_Id = '" + lblPropertyID.Text + "'";

        objConn.ExecSQL(_sql, out errCode, out errMsg);

        if (errCode == -1)
        {
            lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
            lblSysErrMsg.Text = errMsg;
        }
        else
        {
            Response.Redirect("PropListing.aspx");
        }
    }

    public void pageMode(int _mode, string _PID)
    {
        //txtEAppPropRefID
        if (_mode == EDIT_MODE)
        {
      

            dbConn objConn = new dbConn();
            int errCode;
            string errMsg;
            DataTable mDt = new DataTable();

            btnSave.Visible = false;
            btnUpdate.Visible = true;
            btnSold.Visible = true;
            btnRented.Visible = true;
            ImgBtnUploadPhoto.Enabled = true;

            string askingPrice;

            string _sql = "SELECT L.location, L.PropertyCode, L.PropertyType, L.BuiltUp_Area, L.Land_Area, L.PDesc, L.PropertySpec, " +
                          "L.PropertyCondition, L.FurnishedCondition, L.Tenure, L.NoOfBedRoom, L.NoOfBathRoom, L.CarPark, L.Exclusive, " +
                          "L.TYear, L.ExpiredDate, " +
                          "L.AskingPrice, L.RentingPrice, L.AppRefPID, L.PStatus, T.PropertyDesc " +
                          "FROM tblPropListing L INNER JOIN tblPropType T ON T.ID = L.PropertyType " +
                          "WHERE Ref_Cd & Ref_Id = '" + _PID + "'";

            mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

            if (errCode == 0)
            {
                DataRow DR;
                DR = mDt.Rows[0];
                lblPropertyID.Text = _PID;

                // None editable
                ddlPropertyCat.SelectedValue = _PID.Substring(0, 1);
                WUCFT.selectedValue = DR["location"].ToString();
                lblPropType.Text = DR["PropertyDesc"].ToString();

              
                ddlPropType.Attributes.Add("style", "visibility :hidden");
                ddlPropertyCat.Enabled = false;
                ddlPropType.Enabled = false;
                lblPropType.Visible = true;

                askingPrice = DR["AskingPrice"].ToString();

                if (DR["PStatus"].ToString() == "2")
                {
                    btnSold.Visible = false;
                }

                if (askingPrice.Length > 6)
                {
                    txtAskingPrice.Text = Convert.ToString(float.Parse(askingPrice) / 1000000);
                    cbThous.Checked = false;
                    cbMil.Checked = true;
                }
                else if ((askingPrice.Length > 3 && Convert.ToDecimal(askingPrice) > 0) && (askingPrice.Length < 7))
                {
                    txtAskingPrice.Text = Convert.ToString(float.Parse(askingPrice) / 1000);
                    cbThous.Checked = true;
                    cbMil.Checked = false;
                }
                else
                {
                    cbMil.Checked = false;
                    cbThous.Checked = false;
                    txtAskingPrice.Text = (Convert.ToDecimal(askingPrice) > 0)?  askingPrice : "0";
                }

                string rentingPrice = DR["RentingPrice"].ToString();

                if (rentingPrice.Length > 3 && Convert.ToDecimal(rentingPrice) > 0)
                {
                    txtRentingPrice.Text = Convert.ToString(float.Parse(rentingPrice) / 1000);
                    cbThousRenting.Checked = true;
                }
                else
                {
                    txtRentingPrice.Text = (Convert.ToDecimal(rentingPrice) > 0)? rentingPrice : "0";
                }

                txtEAppPropRefID.Text = DR["AppRefPID"].ToString();
                txtrdProjName.Text = DR["PropertyCode"].ToString();

                if (DR["Exclusive"].ToString() == "1")
                {
                    cbExclusive.Checked = true;
                }
                else
                {
                    cbExclusive.Checked = false;
                }

                txtBoxAppNoBathroom.Text = DR["NoOfBathRoom"].ToString();
                txtBoxAppNoBedroom.Text = DR["NoOfBedRoom"].ToString();
                txtBoxLandedNoBathroom.Text = DR["NoOfBathRoom"].ToString();
                txtBoxLandedNoBedroom.Text = DR["NoOfBedRoom"].ToString();
              
                rdBtnListTenure.SelectedValue = DR["Tenure"].ToString();
                rdBtnListPropCond.SelectedValue = DR["PropertyCondition"].ToString();
                rdBtnListFurCond.SelectedValue = DR["FurnishedCondition"].ToString();
                txtLandArea.Text = DR["Land_Area"].ToString();
                txtBuiltUpArea.Text = DR["BuiltUp_Area"].ToString();
                txtDesc.Text = DR["PDesc"].ToString();

                txtLeaseHoldYear.Text = DR["TYear"].ToString();
                txtExpiredYear.Text = DR["ExpiredDate"].ToString();

                if (_PID.StartsWith("S"))
                {
                    Tabs.ActiveTabIndex = 1;
                    this.txtFloor.Text = DR["PropertySpec"].ToString();
                    txtNumberOfCarPark.Text = DR["CarPark"].ToString();
                }
                else if (_PID.StartsWith("L"))
                {
                    Tabs.ActiveTabIndex = 2;
                    ddlLandedStorey.SelectedValue = DR["PropertySpec"].ToString();
                }
                else if (_PID.StartsWith("C"))
                {
                    Tabs.ActiveTabIndex = 3;
                }
                else if (_PID.StartsWith("F"))
                {
                    Tabs.ActiveTabIndex = 4;
                }

            }
            else
            {
                lblSysErrMsg.ForeColor = System.Drawing.Color.Red;
                lblSysErrMsg.Text = errMsg;
            }
        }
        else
        {
            cbThous.Checked = true;
            btnSave.Visible = true;
            btnUpdate.Visible = false;
            btnSold.Visible = false;
            ImgBtnUploadPhoto.Enabled = false;
            btnRented.Visible = false;
        }


        Master.checkSessionExpired();

        if (Session["user_accesslevel"].ToString() == "1")
        {
            cbExclusive.Enabled = true;
        }
        else
        {
            cbExclusive.Enabled = false;
        }
    }

    public void pageInit()
    {
        if (Request.QueryString["PID"] == null)
        {   pageMode(NEW_MODE, "0");    }
        else
        {   
            pageMode(EDIT_MODE, Request.QueryString["PID"].ToString());
            loadPropertyImg();
        }
    }

    public void loadPropertyImg()
    {
        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;

        string _sql;
        string LID = lblPropertyID.Text;

        _sql = "SELECT ImageFileName, ImageThumbNailLocation_1, ImageProfilePic FROM tblPropImage WHERE " +
               "Ref_Cd & Ref_Id = '" + LID + "'";

        DataTable mDt = new DataTable();

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);

        //Label1.Text = "Total Photo : " + mDt.Rows.Count;
        lblTotalPhoto.Text = mDt.Rows.Count.ToString();

        DLImgGallery.DataSource = mDt;
        DLImgGallery.DataBind();
    }

    public bool FnCast(string vi)
    {
        //if (vi == "1"
        bool rtn = (vi == "1") ? true : false;
        return rtn;
    }

    private void loadXmlData()
    {
        XmlDocument doc = new XmlDocument();
        doc.Load(Server.MapPath("App_Data/eliteSysConfig.xml"));
        XmlNode root = doc.DocumentElement;
        string ImgFileSize = root.SelectSingleNode("ImgFileSize").ChildNodes[0].Value;
        lblMaxSize.Text = ImgFileSize;
    }



    #endregion




    protected void Button1_Click(object sender, EventArgs e)
    {
        string abc = Session["user_accesslevel"].ToString();
    }
}
      //<!--
      //                          <asp:RangeValidator Display="Dynamic" ControlToValidate="txtExpiredYear"
      //                              ID="RangeValidator1" runat="server" ErrorMessage="Please key proper value" MinimumValue="2000" MaximumValue="3500"></asp:RangeValidator>
      //                              -->

       //<asp:RequiredFieldValidator ID="RFVPropType" runat="server" ErrorMessage="Please select property type" ForeColor="red"
       //                             InitialValue="" Display="Dynamic" ControlToValidate="ddlPropType"></asp:RequiredFieldValidator>