using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

public partial class propertyByCategory : System.Web.UI.Page
{
    #region event

    protected void usrCtrlSearchClickHere(object sender, EventArgs e)
    {
      string PropCat = Request.QueryString["Cat"].ToString();
      loadListing(PropCat);
    }
    

    #endregion

    #region User Defined Function

    private void loadListing(string PropCat)
    {

        dbConn objConn = new dbConn();
        int errCode;
        string errMsg;
        DataTable mDt = new DataTable();

        string _sql;

        if (PropCat == "E")
        {
            _sql = "SELECT P.Ref_Cd & P.Ref_Id AS PID, P.Location, P.PropertyCode, " +
                   "P.PropertyType, P.BuiltUp_Area, P.Land_Area, P.PropertyCondition, P.Tenure, P.PStatus, P.InsDate, " +
                   "P.AskingPrice, P.RentingPrice, P.Exclusive, L.Loc_Name, T.PropertyDesc, " +
                   "I.ImageFileLocation, ImageThumbNailLocation_1 " +
                   "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.Location = L.Loc_Code) " +
                   "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
                   "LEFT JOIN tblPropImage I ON P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id " +
                   "WHERE " +
                   "P.Exclusive = 1 " +
                   "AND I.ImageAutoID = " +
                   "(SELECT MAX(I2.ImageAutoID) FROM tblPropImage I2 WHERE I2.Ref_Cd & I2.Ref_Id = P.Ref_Cd & P.Ref_Id AND I2.ImageProfilePic = 1)";
        }
        else
        {
            // no primary picture set or picture, the listing wont display
            // If new added no appear, it appear under exclusive
            // Under Pending not appear here 13 Feb 2011
            _sql = "SELECT P.Ref_Cd & P.Ref_Id AS PID, P.Location, P.PropertyCode, " +
                         "P.PropertyType, P.BuiltUp_Area, P.Land_Area, P.PropertyCondition, P.Tenure, P.InsDate, " +
                         "P.AskingPrice, P.RentingPrice, P.Exclusive, L.Loc_Name, T.PropertyDesc, P.PStatus, " +
                         "I.ImageFileLocation, I.ImageThumbNailLocation_1 " +
                         "FROM ((tblPropListing P INNER JOIN tblPropLocation L ON P.Location = L.Loc_Code) " +
                         "INNER JOIN tblPropType T ON P.PropertyType = T.ID) " +
                         "LEFT JOIN tblPropImage I ON P.Ref_Cd & P.Ref_Id = I.Ref_Cd & I.Ref_Id " +
                         "WHERE " +
                         "LEFT(P.Ref_Cd, 1) = '" + PropCat + "' " +
                         "AND P.Exclusive = 0 " +
                         "AND (I.ImageAutoID = " +
                         "(SELECT MAX(I2.ImageAutoID) FROM tblPropImage I2 WHERE I2.Ref_Cd & I2.Ref_Id = P.Ref_Cd & P.Ref_Id AND I2.ImageProfilePic = 1)" +
                         "OR I.ImageAutoID is null ) " +
                         "AND P.PActive = 1";
        }


 

        // Precedence
        if (!string.IsNullOrEmpty(WUCFT.propertyID))
        {
            _sql = _sql + " AND P.Ref_Cd & P.Ref_Id = '" + WUCFT.propertyID.Trim() + "'";
        }
        else
        {

            // Sales, ToLet, Both
            // Keyword

            if (WUCFT.PropertyTag == "Sales")
            { _sql = _sql + " AND P.AskingPrice <> 0 AND P.RentingPrice = 0"; }
            else if (WUCFT.PropertyTag == "ToLet")
            { _sql = _sql + " AND P.RentingPrice <> 0 AND P.AskingPrice = 0"; } 

            if ((WUCFT.location != "0") && (!string.IsNullOrEmpty(WUCFT.location)))
            {
                _sql = _sql + "AND location = '" + WUCFT.location + "'";
            }

            if (PropCat == "E")
            {

            }
        


        }

        _sql = _sql + " ORDER BY P.InsDate";

        mDt = objConn.GetDataReader2Dt(_sql, out errCode, out errMsg);


        DLProperty.DataSource = mDt;
        DLProperty.DataBind();
        mDt.Clear();

    }

    #endregion

    protected void Page_Load(object sender, EventArgs e)
    {

        HtmlLink link = new HtmlLink();
        link.Href = "CSS/mainContainerStyle.css";
        link.Attributes.Add("rel", "stylesheet");
        link.Attributes.Add("type", "text/css");
        Page.Header.Controls.Add(link);

     //  this.WebUserControl1.usrCtrlSaveClick += new EventHandler(this.usrctrlSaveClick);
        WUCFT.usrCtrlSearchClick += new EventHandler(usrCtrlSearchClickHere);

        if (!Page.IsPostBack)
        {

            if (Request.QueryString["Cat"] != null)
            {

            string PropCat = Request.QueryString["Cat"].ToString();

            #region Init Web User Control

            // intialValue

            WUCFT.intialValue = "1000";

            if (PropCat != "E")
            {
                WUCFT.propCat = PropCat;
                WUCFT.propCatEnabled = false;
              
            }
            else
            {
               
            }
            
            #endregion


            switch (PropCat)
            {
                case "S":
                    lblPropertyCat.Text = "Apartment / Condominium";
                    break;
                
                case "L":
                    lblPropertyCat.Text = "Landed Houses";
                    break;

                case "C":
                    lblPropertyCat.Text = "Commercial";
                    break;

                case "F":
                    lblPropertyCat.Text = "Factories & Land";
                    break;

                case "E":
                    lblPropertyCat.Text = "Exclusive";
                    break;
            }

            loadListing(PropCat);


            }

        }
    }

    protected void DLProperty_ItemDataBound(object sender, DataListItemEventArgs e)
    {

        if (e.Item.ItemType == ListItemType.Item ||
        e.Item.ItemType == ListItemType.AlternatingItem)
        {
            DataRowView drv = (DataRowView)(e.Item.DataItem);
            string askingPrice = drv["AskingPrice"].ToString();

            CUtil outil = new CUtil();

            Label lbl = (Label)e.Item.FindControl("lblAskingPrice");
            lbl.Text = outil.factorPrice(askingPrice);

            if (drv["PStatus"].ToString() == "2")
            {
                StringBuilder sb = new StringBuilder();
                sb.Append("<div class='soldThumbNail'>");
                sb.Append("<img src='Images/Item/main_icon_sold.gif' alt='sold' />");
                sb.Append("</div>");

                Literal lit;
                lit = (Literal)e.Item.FindControl("ltSoldIcon");
                lit.Text = sb.ToString();
            }
            else
            {
                // Sold would fall in here
                DateTime Tday = DateTime.Now;
                DateTime Iday = Convert.ToDateTime(drv["InsDate"]);
                TimeSpan span = Tday.Subtract(Iday);

                if (span.Days <= 7)
                {
                    StringBuilder sb = new StringBuilder();
                    sb.Append("<div class='newThumbNail'>");
                    sb.Append("<img src='Images/Item/new_icon.gif' alt='new' style='float:right;'/>");
                    sb.Append("</div>");

                    Literal lit;
                    lit = (Literal)e.Item.FindControl("ltSoldIcon");
                    lit.Text = sb.ToString();
                }
            }

            if (drv["ImageThumbNailLocation_1"].ToString() == "")
            {
                Image imgBtn = (Image)e.Item.FindControl("ImgHighProperty");
                imgBtn.ImageUrl = "Images/Item/nolistings.gif";

            }


            if (Convert.ToDecimal(drv["AskingPrice"].ToString()) < 1)
            {
                Label lblAsking = (Label)e.Item.FindControl("lblAskingPrice");
                lblAsking.Text = "-";
            }

            if (Convert.ToDecimal(drv["RentingPrice"].ToString()) < 1)
            {
                Label lblRental = (Label)e.Item.FindControl("lblRentingPrice");
                lblRental.Text = "-";
            }



        }
    }
}
